/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBHashAndRangeKeyExtractingEntityMetadata;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBIdIsHashAndRangeKeyEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.FieldAndGetterReflectionEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.support.HashAndRangeKeyExtractor;
import org.springframework.data.annotation.Id;

public class DynamoDBIdIsHashAndRangeKeyEntityInformationImpl<T, ID>
extends FieldAndGetterReflectionEntityInformation<T, ID>
implements DynamoDBIdIsHashAndRangeKeyEntityInformation<T, ID> {
    private DynamoDBHashAndRangeKeyExtractingEntityMetadata<T, ID> metadata;
    private HashAndRangeKeyExtractor<ID, ?> hashAndRangeKeyExtractor;
    private Optional<String> projection = Optional.empty();
    private Optional<Integer> limit = Optional.empty();

    public DynamoDBIdIsHashAndRangeKeyEntityInformationImpl(Class<T> domainClass, DynamoDBHashAndRangeKeyExtractingEntityMetadata<T, ID> metadata) {
        super(domainClass, Id.class);
        this.metadata = metadata;
        this.hashAndRangeKeyExtractor = metadata.getHashAndRangeKeyExtractor(this.getIdType());
    }

    @Override
    public Optional<String> getProjection() {
        return this.projection;
    }

    @Override
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @Override
    public boolean isRangeKeyAware() {
        return true;
    }

    @Override
    public Object getHashKey(ID id) {
        return this.hashAndRangeKeyExtractor.getHashKey(id);
    }

    @Override
    public Object getRangeKey(ID id) {
        return this.hashAndRangeKeyExtractor.getRangeKey(id);
    }

    @Override
    public Optional<String> getOverriddenAttributeName(String attributeName) {
        return this.metadata.getOverriddenAttributeName(attributeName);
    }

    @Override
    public boolean isHashKeyProperty(String propertyName) {
        return this.metadata.isHashKeyProperty(propertyName);
    }

    @Override
    public boolean isCompositeHashAndRangeKeyProperty(String propertyName) {
        return this.metadata.isCompositeHashAndRangeKeyProperty(propertyName);
    }

    @Override
    public String getRangeKeyPropertyName() {
        return this.metadata.getRangeKeyPropertyName();
    }

    @Override
    public <V extends DynamoDBMarshaller<?>> V getMarshallerForProperty(String propertyName) {
        return this.metadata.getMarshallerForProperty(propertyName);
    }

    @Override
    public DynamoDBTypeConverter<?, ?> getTypeConverterForProperty(String propertyName) {
        return this.metadata.getTypeConverterForProperty(propertyName);
    }

    @Override
    public Set<String> getIndexRangeKeyPropertyNames() {
        return this.metadata.getIndexRangeKeyPropertyNames();
    }

    @Override
    public String getHashKeyPropertyName() {
        return this.metadata.getHashKeyPropertyName();
    }

    @Override
    public <H> HashAndRangeKeyExtractor<ID, H> getHashAndRangeKeyExtractor(Class<ID> idClass) {
        return this.metadata.getHashAndRangeKeyExtractor(idClass);
    }

    @Override
    public String getDynamoDBTableName() {
        return this.metadata.getDynamoDBTableName();
    }

    @Override
    public Map<String, String[]> getGlobalSecondaryIndexNamesByPropertyName() {
        return this.metadata.getGlobalSecondaryIndexNamesByPropertyName();
    }

    @Override
    public <H> T getHashKeyPropotypeEntityForHashKey(H hashKey) {
        return this.metadata.getHashKeyPropotypeEntityForHashKey(hashKey);
    }

    @Override
    public boolean isGlobalIndexHashKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexHashKeyProperty(propertyName);
    }

    @Override
    public boolean isGlobalIndexRangeKeyProperty(String propertyName) {
        return this.metadata.isGlobalIndexRangeKeyProperty(propertyName);
    }
}

