/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBTemplate;
import org.socialsignin.spring.data.dynamodb.mapping.DynamoDBMappingContext;
import org.socialsignin.spring.data.dynamodb.repository.config.DynamoDBMapperConfigFactory;
import org.socialsignin.spring.data.dynamodb.repository.config.DynamoDBMapperFactory;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBRepositoryFactoryBean;
import org.socialsignin.spring.data.dynamodb.repository.util.DynamoDBMappingContextProcessor;
import org.socialsignin.spring.data.dynamodb.repository.util.Entity2DynamoDBTableSynchronizer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DynamoDBRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBRepositoryConfigExtension.class);
    private static final String DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME = "amazonDynamoDB";
    private static final String DYNAMO_DB_MAPPER_CONFIG_REF = "dynamodb-mapper-config-ref";
    private static final String DYNAMO_DB_OPERATIONS_REF = "dynamodb-operations-ref";
    private static final String AMAZON_DYNAMODB_REF = "amazon-dynamodb-ref";
    private static final String MAPPING_CONTEXT_REF = "mapping-context-ref";
    private BeanDefinitionRegistry registry;
    private String defaultDynamoDBMappingContext;
    private Map<String, String> dynamoDBTemplateCache = new HashMap<String, String>();
    private final Map<String, String> entity2DynamoDBTableSynchronizerCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> dynamoDBMappingContextProcessorCache = new ConcurrentHashMap<String, String>();
    private String dynamoDBMapperName;
    private String dynamoDBMapperConfigName;

    public String getRepositoryFactoryBeanClassName() {
        return DynamoDBRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        String repositoryBeanName = config.generateBeanName((BeanDefinition)builder.getBeanDefinition());
        this.postProcess(builder, repositoryBeanName, attributes.getString("amazonDynamoDBRef"), attributes.getString("dynamoDBMapperConfigRef"), attributes.getString("dynamoDBOperationsRef"), attributes.getString("mappingContextRef"));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)AMAZON_DYNAMODB_REF, (String)DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME);
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)DYNAMO_DB_MAPPER_CONFIG_REF, (String)"dynamoDBMapperConfig");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)DYNAMO_DB_OPERATIONS_REF, (String)"dynamoDBOperations");
        String dynamoDBMappingContextRef = element.getAttribute(MAPPING_CONTEXT_REF);
        if (!StringUtils.hasText((String)dynamoDBMappingContextRef)) {
            if (this.defaultDynamoDBMappingContext == null) {
                this.defaultDynamoDBMappingContext = this.registerDynamoDBMappingContext(this.registry);
            }
            dynamoDBMappingContextRef = this.defaultDynamoDBMappingContext;
        }
        this.registerAndSetPostProcessingBeans(builder, this.registry, dynamoDBMappingContextRef);
    }

    private void postProcess(BeanDefinitionBuilder builder, String repositoryName, String amazonDynamoDBRef, String dynamoDBMapperConfigRef, String dynamoDBOperationsRef, String dynamoDBMappingContextRef) {
        if (StringUtils.hasText((String)dynamoDBOperationsRef)) {
            builder.addPropertyReference("dynamoDBOperations", dynamoDBOperationsRef);
            Assert.isTrue((!StringUtils.hasText((String)amazonDynamoDBRef) ? 1 : 0) != 0, (String)"Cannot specify both amazonDynamoDB bean and dynamoDBOperationsBean in repository configuration");
            Assert.isTrue((!StringUtils.hasText((String)dynamoDBMapperConfigRef) ? 1 : 0) != 0, (String)"Cannot specify both dynamoDBMapperConfigBean bean and dynamoDBOperationsBean in repository configuration");
        } else {
            if (StringUtils.isEmpty((Object)dynamoDBOperationsRef)) {
                String dynamoDBRef = StringUtils.hasText((String)amazonDynamoDBRef) ? amazonDynamoDBRef : DEFAULT_AMAZON_DYNAMO_DB_BEAN_NAME;
                dynamoDBOperationsRef = this.dynamoDBTemplateCache.computeIfAbsent(this.getBeanNameWithModulePrefix("DynamoDBTemplate-" + dynamoDBRef), ref -> {
                    BeanDefinitionBuilder dynamoDBTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamoDBTemplate.class);
                    dynamoDBTemplateBuilder.addConstructorArgReference(dynamoDBRef);
                    dynamoDBTemplateBuilder.addConstructorArgReference(this.dynamoDBMapperName);
                    if (StringUtils.hasText((String)dynamoDBMapperConfigRef)) {
                        dynamoDBTemplateBuilder.addConstructorArgReference(dynamoDBMapperConfigRef);
                    } else {
                        dynamoDBTemplateBuilder.addConstructorArgReference(this.dynamoDBMapperConfigName);
                    }
                    this.registry.registerBeanDefinition(ref, (BeanDefinition)dynamoDBTemplateBuilder.getBeanDefinition());
                    return ref;
                });
            }
            builder.addPropertyReference("dynamoDBOperations", dynamoDBOperationsRef);
        }
        if (!StringUtils.hasText((String)dynamoDBMappingContextRef)) {
            if (this.defaultDynamoDBMappingContext == null) {
                this.defaultDynamoDBMappingContext = this.registerDynamoDBMappingContext(this.registry);
            }
            dynamoDBMappingContextRef = this.defaultDynamoDBMappingContext;
        }
        builder.addPropertyReference("dynamoDBMappingContext", dynamoDBMappingContextRef);
        this.registerAndSetPostProcessingBeans(builder, this.registry, dynamoDBMappingContextRef);
    }

    protected void registerAndSetPostProcessingBeans(BeanDefinitionBuilder builder, BeanDefinitionRegistry registry, String dynamoDBMappingContextRef) {
        String tableSynchronizerName = this.registerEntity2DynamoDBTableSynchronizer(registry, dynamoDBMappingContextRef);
        builder.addPropertyReference("entity2DynamoDBTableSynchronizer", tableSynchronizerName);
        String dynamoDBMappingContextProcessorName = this.registerDynamoDBMappingContextProcessor(registry, dynamoDBMappingContextRef);
        builder.addPropertyReference("dynamoDBMappingContextProcessor", dynamoDBMappingContextProcessorName);
    }

    private String registerEntity2DynamoDBTableSynchronizer(BeanDefinitionRegistry registry, String dynamoDBMappingContextRef) {
        assert (registry != null);
        return this.entity2DynamoDBTableSynchronizerCache.computeIfAbsent(dynamoDBMappingContextRef, ref -> {
            BeanDefinitionBuilder entity2DynamoDBTableSynchronizerBuilder = BeanDefinitionBuilder.genericBeanDefinition(Entity2DynamoDBTableSynchronizer.class);
            String tableSynchronizerName = this.getBeanNameWithModulePrefix("Entity2DynamoDBTableSynchronizer-" + dynamoDBMappingContextRef);
            registry.registerBeanDefinition(tableSynchronizerName, (BeanDefinition)entity2DynamoDBTableSynchronizerBuilder.getBeanDefinition());
            return tableSynchronizerName;
        });
    }

    private String registerDynamoDBMappingContextProcessor(BeanDefinitionRegistry registry, String dynamoDBMappingContextRef) {
        assert (registry != null);
        return this.dynamoDBMappingContextProcessorCache.computeIfAbsent(dynamoDBMappingContextRef, ref -> {
            BeanDefinitionBuilder dynamoDBMappingContextProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamoDBMappingContextProcessor.class);
            dynamoDBMappingContextProcessorBuilder.addConstructorArgReference(dynamoDBMappingContextRef);
            String dynamoDBMappingContextProcessorRef = this.getBeanNameWithModulePrefix("DynamoDBMappingContextProcessor-" + dynamoDBMappingContextRef);
            registry.registerBeanDefinition(dynamoDBMappingContextProcessorRef, (BeanDefinition)dynamoDBMappingContextProcessorBuilder.getBeanDefinition());
            return dynamoDBMappingContextProcessorRef;
        });
    }

    private String registerDynamoDBMappingContext(BeanDefinitionRegistry registry) {
        assert (registry != null);
        BeanDefinitionBuilder dynamoDBMappingContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamoDBMappingContext.class);
        String dynamoDBMappingContextRef = this.getBeanNameWithModulePrefix("DynamoDBMappingContext");
        LOGGER.debug("Adding bean <{}> of type <{}>", (Object)dynamoDBMappingContextRef, (Object)dynamoDBMappingContextBuilder.getBeanDefinition());
        registry.registerBeanDefinition(dynamoDBMappingContextRef, (BeanDefinition)dynamoDBMappingContextBuilder.getBeanDefinition());
        return dynamoDBMappingContextRef;
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        this.registry = registry;
        this.dynamoDBMapperConfigName = this.getBeanNameWithModulePrefix("DynamoDBMapperConfig");
        Optional dynamoDBMapperConfigRef = configurationSource.getAttribute("dynamoDBMapperConfigRef");
        if (!dynamoDBMapperConfigRef.isPresent()) {
            BeanDefinitionBuilder dynamoDBMapperConfigBuiilder = BeanDefinitionBuilder.genericBeanDefinition(DynamoDBMapperConfigFactory.class);
            registry.registerBeanDefinition(this.dynamoDBMapperConfigName, (BeanDefinition)dynamoDBMapperConfigBuiilder.getBeanDefinition());
        }
        this.dynamoDBMapperName = this.getBeanNameWithModulePrefix("DynamoDBMapper");
        BeanDefinitionBuilder dynamoDBMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamoDBMapperFactory.class);
        registry.registerBeanDefinition(this.dynamoDBMapperName, (BeanDefinition)dynamoDBMapperBuilder.getBeanDefinition());
    }

    protected String getBeanNameWithModulePrefix(String baseBeanName) {
        return String.format("%s-%s", this.getModulePrefix(), baseBeanName);
    }

    protected String getModulePrefix() {
        return "dynamoDB";
    }
}

