/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperaDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(OperaDriverManager.class)) {
            instance = new OperaDriverManager();
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        if (this.isUsingTaobaoMirror()) {
            urls = this.getDriversFromMirror(driverUrl);
        } else {
            String driverVersion = this.versionToDownload;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
            if (driverVersion != null) {
                releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
            }
            urls = new ArrayList<URL>();
            for (GitHubApi release : releaseArray) {
                if (release == null) continue;
                List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                for (LinkedTreeMap<String, Object> asset : assets) {
                    urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                }
            }
            reader.close();
        }
        return urls;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.operaDriverExport");
    }

    protected GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            if (release.getName() == null || !release.getName().equalsIgnoreCase(version)) continue;
            out = release;
            break;
        }
        return out;
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("operadriver");
    }

    @Override
    protected String getDriverVersionKey() {
        return "wdm.operaDriverVersion";
    }

    @Override
    protected String getDriverUrlKey() {
        return "wdm.operaDriverUrl";
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) throws MalformedURLException {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return url.getFile().substring(url.getFile().indexOf("/v") + 2, url.getFile().lastIndexOf("/"));
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        try {
            this.driverUrl = new URL(WdmConfig.getString("wdm.operaDriverTaobaoUrl"));
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", (Throwable)e);
            throw new RuntimeException(e);
        }
        return instance;
    }
}

