/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(EdgeDriverManager.class)) {
            instance = new EdgeDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws Exception {
        String edgeDriverUrl = WdmConfig.getString("wdm.edgeDriverUrl");
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)edgeDriverUrl);
        Document doc = Jsoup.connect((String)edgeDriverUrl).timeout((int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"))).proxy(this.createProxy()).get();
        Elements downloadLink = doc.select("ul.driver-downloads li.driver-download > a");
        Elements versionParagraph = doc.select("ul.driver-downloads li.driver-download p.driver-download__meta");
        String[] latestVersion = ((Element)versionParagraph.get(0)).text().split(" ");
        this.versionToDownload = latestVersion[1];
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(new URL(((Element)downloadLink.get(0)).attr("href")));
        return urlList;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.edgeExport");
    }

    @Override
    protected String getDriverVersionKey() {
        return "wdm.edgeVersion";
    }

    @Override
    protected String getDriverUrlKey() {
        return "wdm.edgeDriverUrl";
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("MicrosoftWebDriver");
    }
}

