/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class OperaDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.OPERA;
    }

    @Override
    protected String getDriverName() {
        return "operadriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getOperaDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getOperaDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getOperaDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getOperaDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setOperaDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setOperaDriverUrl(url);
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.config.isUseMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return url.getFile().substring(url.getFile().indexOf("/v") + 2, url.getFile().lastIndexOf("/"));
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return this.getDriversFromGitHub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File postDownload(File archive) {
        log.trace("Post processing for Opera: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        if (!extractFolder.isFile()) {
            File target;
            try {
                File operadriver;
                boolean isOperaDriver;
                log.trace("Opera extract folder (to be deleted): {}", (Object)extractFolder);
                File[] listFiles = extractFolder.listFiles();
                int i = 0;
                do {
                    if (i >= listFiles.length) {
                        throw new WebDriverManagerException("Driver binary for Opera not found in zip file");
                    }
                    operadriver = listFiles[i];
                    isOperaDriver = this.config().isExecutable(operadriver) && operadriver.getName().contains(this.getDriverName());
                    ++i;
                    log.trace("{} is valid: {}", (Object)operadriver, (Object)isOperaDriver);
                } while (!isOperaDriver);
                log.info("Operadriver binary: {}", (Object)operadriver);
                target = new File(archive.getParentFile().getAbsolutePath(), operadriver.getName());
                log.trace("Operadriver target: {}", (Object)target);
                this.downloader.renameFile(operadriver, target);
            }
            finally {
                this.downloader.deleteFolder(extractFolder);
            }
            return target;
        }
        return super.postDownload(archive);
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        return this.getDefaultBrowserVersion("PROGRAMFILES", "\\\\Opera\\\\launcher.exe", "opera", "/Applications/Opera.app/Contents/MacOS/Opera", "--version", "");
    }
}

