/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.VoidDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class WebDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance(Class<?> webDriverClass) {
        Class browserManagerClass = null;
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                browserManagerClass = ChromeDriverManager.class;
                break;
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                browserManagerClass = OperaDriverManager.class;
                break;
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                browserManagerClass = InternetExplorerDriverManager.class;
                break;
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                browserManagerClass = EdgeDriverManager.class;
                break;
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                browserManagerClass = PhantomJsDriverManager.class;
                break;
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                browserManagerClass = FirefoxDriverManager.class;
                break;
            }
            default: {
                browserManagerClass = VoidDriverManager.class;
            }
        }
        if (instance == null || instance.getClass() != browserManagerClass) {
            try {
                instance = (BrowserManager)browserManagerClass.newInstance();
            }
            catch (Exception e) {
                throw new WebDriverManagerException(e);
            }
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return instance.getDrivers();
    }
}

