/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.common.io.Files;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    protected static final Logger log = LoggerFactory.getLogger(Downloader.class);
    private static final String HOME = "~";

    public static final synchronized void download(URL url, String version, String export, List<String> driverName) throws IOException {
        boolean download;
        File targetFile = new File(Downloader.getTarget(version, url));
        File binary = null;
        boolean bl = download = !targetFile.getParentFile().exists() || targetFile.getParentFile().exists() && targetFile.getParentFile().list().length == 0 || WdmConfig.getBoolean("wdm.override");
        if (!download) {
            Collection listFiles = FileUtils.listFiles((File)targetFile.getParentFile(), null, (boolean)true);
            for (File file : listFiles) {
                for (String s : driverName) {
                    if (file.getName().startsWith(s) && file.canExecute()) {
                        binary = file;
                        log.debug("Using binary driver previously downloaded {}", (Object)binary);
                        download = false;
                        break;
                    }
                    download = true;
                }
                if (download) continue;
                break;
            }
        }
        if (download) {
            log.info("Downloading {} to {}", (Object)url, (Object)targetFile);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.addRequestProperty("Connection", "keep-alive");
            conn.connect();
            FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)targetFile);
            if (!export.contains("edge")) {
                binary = Downloader.extract(targetFile, export);
                targetFile.delete();
            } else {
                binary = targetFile;
            }
        }
        if (export != null) {
            BrowserManager.exportDriver(export, binary.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File extractMsi(File msi) throws IOException {
        File tmpMsi = new File(Files.createTempDir().getAbsoluteFile() + File.separator + msi.getName());
        Files.move((File)msi, (File)tmpMsi);
        log.trace("Temporal msi file: {}", (Object)tmpMsi);
        Process process = Runtime.getRuntime().exec(new String[]{"msiexec", "/a", tmpMsi.toString(), "/qb", "TARGETDIR=" + msi.getParent()});
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            log.error("Exception waiting to msiexec to be finished", (Throwable)e);
        }
        finally {
            process.destroy();
        }
        tmpMsi.delete();
        Collection listFiles = FileUtils.listFiles((File)new File(msi.getParent()), (String[])new String[]{"exe"}, (boolean)true);
        return (File)listFiles.iterator().next();
    }

    public static final File extract(File compressedFile, String export) throws IOException {
        log.trace("Compressed file {}", (Object)compressedFile);
        File file = null;
        if (compressedFile.getName().toLowerCase().endsWith("tar.bz2")) {
            file = Downloader.unBZip2(compressedFile, export);
        } else if (compressedFile.getName().toLowerCase().endsWith("gz")) {
            file = Downloader.unGzip(compressedFile);
        } else {
            ZipFile zipFolder = new ZipFile(compressedFile);
            Enumeration<? extends ZipEntry> enu = zipFolder.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                long size = zipEntry.getSize();
                long compressedSize = zipEntry.getCompressedSize();
                log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", new Object[]{name, size, compressedSize});
                file = new File(compressedFile.getParentFile() + File.separator + name);
                if (!file.exists() || WdmConfig.getBoolean("wdm.override")) {
                    int length;
                    if (name.endsWith("/")) {
                        file.mkdirs();
                        continue;
                    }
                    File parent = file.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    InputStream is = zipFolder.getInputStream(zipEntry);
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] bytes = new byte[1024];
                    while ((length = is.read(bytes)) >= 0) {
                        fos.write(bytes, 0, length);
                    }
                    is.close();
                    fos.close();
                    file.setExecutable(true);
                    continue;
                }
                log.debug(file + " already exists");
            }
            zipFolder.close();
        }
        file = Downloader.checkPhantom(compressedFile, export);
        log.trace("Resulting binary file {}", (Object)file.getAbsoluteFile());
        return file.getAbsoluteFile();
    }

    public static File unGzip(File archive) throws IOException {
        int iDot;
        log.trace("UnGzip {}", (Object)archive);
        String fileName = archive.getName();
        int iDash = fileName.indexOf("-");
        if (iDash != -1) {
            fileName = fileName.substring(0, iDash);
        }
        if ((iDot = fileName.indexOf(".")) != -1) {
            fileName = fileName.substring(0, iDot);
        }
        File target = new File(archive.getParentFile() + File.separator + fileName);
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(archive));
             FileOutputStream out = new FileOutputStream(target);){
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
        }
        if (!target.getName().toLowerCase().contains(".exe") && target.exists()) {
            target.setExecutable(true);
        }
        return target;
    }

    public static File unBZip2(File archive, String export) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.BZIP2);
        archiver.extract(archive, archive.getParentFile());
        log.trace("Unbzip2 {}", (Object)archive);
        File target = Downloader.checkPhantom(archive, export);
        return target;
    }

    private static File checkPhantom(File archive, String export) throws IOException {
        File target = null;
        String phantomName = "phantomjs";
        if (export.contains(phantomName)) {
            String fileNoExtension = archive.getName().replace(".tar.bz2", "").replace(".zip", "");
            File phantomjs = null;
            try {
                phantomjs = new File(archive.getParentFile().getAbsolutePath() + File.separator + fileNoExtension + File.separator + "bin" + File.separator).listFiles()[0];
            }
            catch (Exception e) {
                String extension = SystemUtils.IS_OS_WINDOWS ? ".exe" : "";
                phantomjs = new File(archive.getParentFile().getAbsolutePath() + File.separator + fileNoExtension + File.separator + phantomName + extension);
            }
            target = new File(archive.getParentFile().getAbsolutePath() + File.separator + phantomjs.getName());
            phantomjs.renameTo(target);
            File delete = new File(archive.getParentFile().getAbsolutePath() + File.separator + fileNoExtension);
            log.trace("Folder to be deleted: {}", (Object)delete);
            FileUtils.deleteDirectory((File)delete);
        } else {
            File[] ls;
            for (File f : ls = archive.getParentFile().listFiles()) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    if (!f.getName().endsWith(".exe")) continue;
                    target = f;
                    break;
                }
                if (!f.canExecute()) continue;
                target = f;
                break;
            }
        }
        return target;
    }

    public static final String getTarget(String version, URL url) throws IOException {
        log.trace("getTarget {} {}", (Object)version, (Object)url);
        String zip = url.getFile().substring(url.getFile().lastIndexOf("/"));
        int iFirst = zip.indexOf("_");
        int iSecond = zip.indexOf("-");
        int iLast = iFirst != zip.lastIndexOf("_") ? zip.lastIndexOf("_") : (iSecond != -1 ? iSecond : zip.length());
        String folder = zip.substring(0, iLast).replace(".zip", "").replace(".tar.bz2", "").replace(".tar.gz", "").replace(".msi", "").replace(".exe", "").replace("_", File.separator);
        String target = Downloader.getTargetPath() + folder + File.separator + version + zip;
        System.out.println(target);
        if (target.contains("phantomjs")) {
            int iSeparator = target.indexOf(version) - 1;
            int iDash = target.lastIndexOf(version) + version.length();
            int iPoint = target.lastIndexOf(".tar") != -1 ? target.lastIndexOf(".tar") : target.lastIndexOf(".zip");
            target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint) + target.substring(iSeparator);
        } else if (target.contains("wires") || target.contains("geckodriver")) {
            int iSeparator = target.indexOf(version) - 1;
            int iDash = target.lastIndexOf(version) + version.length();
            int iPoint = target.lastIndexOf("tar.gz") != -1 ? target.lastIndexOf(".tar.gz") : (target.lastIndexOf(".gz") != -1 ? target.lastIndexOf(".gz") : target.lastIndexOf(".zip"));
            target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        }
        log.trace("Target file for URL {} version {} = {}", new Object[]{url, version, target});
        return target;
    }

    public static String getTargetPath() {
        File repository;
        String targetPath = WdmConfig.getString("wdm.targetPath");
        if (targetPath.contains(HOME)) {
            targetPath = targetPath.replace(HOME, System.getProperty("user.home"));
        }
        if (!(repository = new File(targetPath)).exists()) {
            repository.mkdirs();
        }
        return targetPath;
    }
}

