/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverVersion;
import io.github.bonigarcia.wdm.OperativeSystem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class BrowserManager {
    protected static final Logger log = LoggerFactory.getLogger(BrowserManager.class);
    private static final String SEPARATOR = "/";
    private static final Architecture DEFAULT_ARCH = Architecture.valueOf("x" + System.getProperty("sun.arch.data.model"));
    private static final String MY_OS_NAME = BrowserManager.getOsName();
    private static final String VERSION_PROPERTY = "wdm.driverVersion";
    protected String versionToDownload;

    protected abstract List<URL> getDrivers(String var1) throws Exception;

    protected abstract String getExportParameter();

    protected abstract String getDriverVersion();

    protected abstract String getDriverName();

    protected abstract URL getDriverUrl() throws MalformedURLException;

    public void setup() {
        this.setup(DEFAULT_ARCH, DriverVersion.NOT_SPECIFIED.name());
    }

    public void setup(String version) {
        this.setup(DEFAULT_ARCH, version);
    }

    public void setup(Architecture arch) {
        this.setup(arch, DriverVersion.NOT_SPECIFIED.name());
    }

    public void setup(Architecture arch, String version) {
        try {
            ((BrowserManager)this.getClass().newInstance()).manage(arch, version.equals(DriverVersion.NOT_SPECIFIED.name()) ? this.getDriverVersion() : version);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void manage(Architecture arch, DriverVersion version) {
        this.manage(arch, version.name());
    }

    public void manage(Architecture arch, String version) {
        try {
            List<URL> candidateUrls;
            boolean continueSearchingVersion;
            boolean getLatest = version == null || version.isEmpty() || version.equalsIgnoreCase(DriverVersion.LATEST.name()) || version.equalsIgnoreCase(DriverVersion.NOT_SPECIFIED.name());
            List<URL> urls = this.getDrivers(version);
            do {
                candidateUrls = getLatest ? this.getLatest(urls, this.getDriverName()) : this.getVersion(urls, this.getDriverName(), version);
                if (this.versionToDownload == null) break;
                boolean bl = continueSearchingVersion = (candidateUrls = this.filter(candidateUrls, arch)).isEmpty() && getLatest;
                if (!continueSearchingVersion) continue;
                log.debug("No valid binary found for {} {}", (Object)this.getDriverName(), (Object)this.versionToDownload);
                urls = this.removeFromList(urls, this.versionToDownload);
                this.versionToDownload = null;
            } while (continueSearchingVersion);
            if (candidateUrls.isEmpty()) {
                String versionStr = getLatest ? "(latest version)" : version;
                String errMessage = this.getDriverName() + " " + versionStr + " for " + MY_OS_NAME + arch.toString() + " not found in " + this.getDriverUrl();
                log.error(errMessage);
                throw new RuntimeException(errMessage);
            }
            for (URL url : candidateUrls) {
                String export = candidateUrls.contains(url) ? this.getExportParameter() : null;
                System.setProperty(VERSION_PROPERTY, this.versionToDownload);
                Downloader.download(url, this.versionToDownload, export);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> filter(List<URL> list, Architecture arch) {
        log.trace("{} {} - URLs before filtering: {}", new Object[]{this.getDriverName(), this.versionToDownload, list});
        ArrayList<URL> out = new ArrayList<URL>();
        for (URL url : list) {
            for (OperativeSystem os : OperativeSystem.values()) {
                if (!MY_OS_NAME.contains(os.name()) || !url.getFile().toLowerCase().contains(os.name())) continue;
                out.add(url);
            }
        }
        log.trace("{} {} - URLs after filtering by OS ({}): {}", new Object[]{this.getDriverName(), this.versionToDownload, MY_OS_NAME, out});
        if (out.size() > 1) {
            for (URL url : list) {
                if (url.getFile().contains(arch.toString())) continue;
                out.remove(url);
            }
        }
        log.trace("{} {} - URLs after filtering by architecture ({}): {}", new Object[]{this.getDriverName(), this.versionToDownload, arch, out});
        return out;
    }

    public List<URL> removeFromList(List<URL> list, String version) {
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version)) continue;
            out.remove(url);
        }
        return out;
    }

    public List<URL> getVersion(List<URL> list, String match, String version) {
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        for (URL url : list) {
            if (!url.getFile().contains(match) || !url.getFile().contains(version)) continue;
            out.add(url);
        }
        this.versionToDownload = version;
        log.debug("Using {} {}", (Object)match, (Object)version);
        return out;
    }

    public List<URL> getLatest(List<URL> list, String match) {
        log.debug("Checking the lastest version of {}", (Object)match);
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        for (URL url : list) {
            if (!url.getFile().contains(match)) continue;
            String currentVersion = url.getFile().substring(url.getFile().indexOf(SEPARATOR) + 1, url.getFile().lastIndexOf(SEPARATOR));
            if (this.versionToDownload == null) {
                this.versionToDownload = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                this.versionToDownload = currentVersion;
                out.clear();
            }
            if (!url.getFile().contains(this.versionToDownload)) continue;
            out.add(url);
        }
        log.debug("Latest version of {} is {}", (Object)match, (Object)this.versionToDownload);
        return out;
    }

    public Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public List<URL> getDriversFromXml(URL driverUrl, String driverBinary) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(driverUrl.openStream()));
        Document xml = this.loadXML(reader);
        ArrayList<URL> urls = new ArrayList<URL>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String version = e.getChildNodes().item(0).getNodeValue();
            urls.add(new URL(driverUrl + version));
        }
        reader.close();
        return urls;
    }

    public Document loadXML(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    public String getDownloadedVersion() {
        return System.getProperty(VERSION_PROPERTY);
    }

    private static String getOsName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (SystemUtils.IS_OS_WINDOWS) {
            os = "win";
        } else if (SystemUtils.IS_OS_LINUX) {
            os = "linux";
        } else if (SystemUtils.IS_OS_MAC) {
            os = "mac";
        }
        return os;
    }
}

