/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class OperaDriverManager
extends BrowserManager {
    @Override
    protected List<URL> getDrivers(Architecture arch, String version) throws IOException {
        GitHubApi release;
        URL driverUrl = WdmConfig.getUrl("wdm.operaDriverUrl");
        String driverVersion = version == null ? WdmConfig.getString("wdm.operaDriverVersion") : version;
        BufferedReader reader = new BufferedReader(new InputStreamReader(driverUrl.openStream()));
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
        if (driverVersion == null || driverVersion.isEmpty() || driverVersion.equalsIgnoreCase("LATEST")) {
            log.info("Connecting to {} to check lastest OperaDriver release", (Object)driverUrl);
            version = releaseArray[0].getName();
            log.info("Latest driver version: {}", (Object)version);
            release = releaseArray[0];
        } else {
            version = driverVersion;
            release = this.getVersion(releaseArray, version);
        }
        if (release == null) {
            throw new RuntimeException("Version " + driverVersion + " is not available for OperaDriver");
        }
        List<LinkedTreeMap<String, Object>> assets = release.getAssets();
        List<URL> urls = new ArrayList<URL>();
        for (LinkedTreeMap<String, Object> asset : assets) {
            urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
        }
        if (WdmConfig.getBoolean("wdm.downloadJustForMySystem")) {
            urls = this.filter(arch, urls);
        }
        reader.close();
        return urls;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.operaDriverExport");
    }

    private GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            if (!release.getName().equalsIgnoreCase(version)) continue;
            out = release;
            break;
        }
        return out;
    }
}

