/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class OperaDriverManager
extends BrowserManager {
    public static void setup(Architecture arch) {
        new OperaDriverManager().manage(arch);
    }

    public static void setup() {
        new OperaDriverManager().manage();
    }

    @Override
    protected List<URL> getDrivers(Architecture arch) throws Exception {
        URL driverUrl = WdmConfig.getUrl("wdm.operaDriverUrl");
        log.info("Connecting to {} to check lastest OperaDriver release", (Object)driverUrl);
        BufferedReader reader = new BufferedReader(new InputStreamReader(driverUrl.openStream()));
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        GitHubApi[] release = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
        this.latestVersion = release[0].getName();
        log.info("Latest driver version: {}", (Object)this.latestVersion);
        List<LinkedTreeMap<String, Object>> assets = release[0].getAssets();
        List<URL> urls = new ArrayList<URL>();
        for (LinkedTreeMap<String, Object> asset : assets) {
            urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
        }
        if (WdmConfig.getBoolean("wdm.downloadJustForMySystem")) {
            urls = this.filter(arch, urls);
        }
        reader.close();
        return urls;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.operaDriverExport");
    }
}

