/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import com.github.dockerjava.api.exception.DockerException;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DockerDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ListDriverHandler
extends DriverHandler {
    private List<DockerDriverHandler> dockerDriverHandlerList = new ArrayList<DockerDriverHandler>();
    private ExecutorService executorService;

    public ListDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            ParameterizedType parameterizedType = (ParameterizedType)this.parameter.getParameterizedType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments[0] != RemoteWebDriver.class && actualTypeArguments[0] != WebDriver.class) {
                throw new SeleniumJupiterException("Invalid type of argument " + parameterizedType + " (expected List<RemoteWebDriver> or List<WebDriver>)");
            }
            Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(this.parameter);
            if (dockerBrowser.isPresent()) {
                DockerBrowser browser = dockerBrowser.get();
                this.resolveBrowserList(testInstance, browser);
            } else {
                log.warn("Annotation @DockerBrowser should be declared");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void resolveBrowserList(Optional<Object> testInstance, DockerBrowser dockerBrowser) throws DockerException, InterruptedException {
        CopyOnWriteArrayList<RemoteWebDriver> driverList = new CopyOnWriteArrayList<RemoteWebDriver>();
        int numBrowsers = dockerBrowser.size();
        CountDownLatch latch = new CountDownLatch(numBrowsers);
        BrowserInstance browserInstance = new BrowserInstance(this.config, this.annotationsReader, dockerBrowser.type(), dockerBrowser.cloud(), Optional.ofNullable(dockerBrowser.browserName()), Optional.ofNullable(dockerBrowser.volumes()));
        String version = dockerBrowser.version();
        String url = dockerBrowser.url();
        if (url != null && !url.isEmpty()) {
            this.dockerService.updateDockerClient(url);
        }
        DockerDriverHandler firstDockerDriverHandler = new DockerDriverHandler(this.context, this.parameter, testInstance, this.annotationsReader, this.containerMap, this.dockerService, this.config, browserInstance, version);
        firstDockerDriverHandler.setIndex("_0");
        firstDockerDriverHandler.startSelenoidContainer();
        if (this.getConfig().isVnc()) {
            firstDockerDriverHandler.startNoVncContainer();
        }
        this.containerMap = firstDockerDriverHandler.getContainerMap();
        boolean browserListInParallel = this.getConfig().isBrowserListInParallel();
        if (browserListInParallel) {
            this.executorService = Executors.newFixedThreadPool(numBrowsers);
        }
        for (int i = 0; i < numBrowsers; ++i) {
            if (browserListInParallel) {
                int index = i;
                this.executorService.submit(() -> this.resolveDockerBrowser(firstDockerDriverHandler, testInstance, browserInstance, dockerBrowser, driverList, latch, index));
                continue;
            }
            this.resolveDockerBrowser(firstDockerDriverHandler, testInstance, browserInstance, dockerBrowser, driverList, latch, i);
        }
        int timeout = numBrowsers * this.getConfig().getDockerWaitTimeoutSec();
        if (!latch.await(timeout, TimeUnit.SECONDS)) {
            throw new SeleniumJupiterException("Timeout of " + timeout + " seconds waiting for start " + numBrowsers + " dockerized browsers");
        }
        this.object = driverList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDockerBrowser(DockerDriverHandler firstDockerDriverHandler, Optional<Object> testInstance, BrowserInstance browserInstance, DockerBrowser dockerBrowser, List<RemoteWebDriver> driverList, CountDownLatch latch, int index) {
        try {
            DockerDriverHandler dockerDriverHandler = index == 0 ? firstDockerDriverHandler : new DockerDriverHandler(this.context, this.parameter, testInstance, this.annotationsReader, this.containerMap, this.dockerService, this.config, browserInstance, dockerBrowser.version());
            dockerDriverHandler.setIndex("_" + index);
            this.dockerDriverHandlerList.add(dockerDriverHandler);
            driverList.add((RemoteWebDriver)dockerDriverHandler.resolve(dockerBrowser));
        }
        finally {
            latch.countDown();
        }
    }

    @Override
    public void cleanup() {
        if (!this.dockerDriverHandlerList.isEmpty()) {
            this.dockerDriverHandlerList.forEach(DockerDriverHandler::cleanup);
            this.dockerDriverHandlerList.clear();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

