/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Locale;

public class DockerHost {
    private static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    private static final String DEFAULT_WINDOWS_ENDPOINT = "npipe:////./pipe/docker_engine";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 2375;
    private final String host;
    private final URI uri;
    private final URI bindUri;
    private final String address;
    private final int port;
    private final String certPath;
    private final String endpoint;

    private DockerHost(String endpoint, String certPath) {
        if (endpoint.startsWith("unix://")) {
            this.port = 0;
            this.address = DEFAULT_ADDRESS;
            this.host = endpoint;
            this.uri = URI.create(endpoint);
            this.bindUri = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            HostAndPort hostAndPort = HostAndPort.fromString((String)stripped);
            String hostText = hostAndPort.getHost();
            String scheme = Strings.isNullOrEmpty((String)certPath) ? "http" : "https";
            this.port = hostAndPort.getPortOrDefault(DockerHost.defaultPort());
            this.address = Strings.isNullOrEmpty((String)hostText) ? DEFAULT_ADDRESS : hostText;
            this.host = this.address + ":" + this.port;
            this.uri = URI.create(scheme + "://" + this.address + ":" + this.port);
            this.bindUri = URI.create("tcp://" + this.address + ":" + this.port);
        }
        this.endpoint = endpoint;
        this.certPath = certPath;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public URI bindUri() {
        return this.bindUri;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String dockerCertPath() {
        return this.certPath;
    }

    public static DockerHost fromEnv() {
        String host = DockerHost.endpointFromEnv();
        String certPath = DockerHost.certPathFromEnv();
        return new DockerHost(host, certPath);
    }

    public static DockerHost from(String endpoint, String certPath) {
        return new DockerHost(endpoint, certPath);
    }

    public static String defaultDockerEndpoint() {
        String osName = System.getProperty("os.name");
        String os = osName.toLowerCase(Locale.ENGLISH);
        if (os.equalsIgnoreCase("linux") || os.contains("mac")) {
            return DockerHost.defaultUnixEndpoint();
        }
        if (System.getProperty("os.name").equalsIgnoreCase("Windows 10")) {
            return DockerHost.defaultWindowsEndpoint();
        }
        return DockerHost.defaultAddress() + ":" + DockerHost.defaultPort();
    }

    public static String endpointFromEnv() {
        return (String)MoreObjects.firstNonNull((Object)System.getenv("DOCKER_HOST"), (Object)DockerHost.defaultDockerEndpoint());
    }

    public static String defaultUnixEndpoint() {
        return DEFAULT_UNIX_ENDPOINT;
    }

    public static String defaultWindowsEndpoint() {
        return DEFAULT_WINDOWS_ENDPOINT;
    }

    public static String defaultAddress() {
        return DEFAULT_ADDRESS;
    }

    public static int defaultPort() {
        return 2375;
    }

    public static int portFromEnv() {
        String port = System.getenv("DOCKER_PORT");
        if (port == null) {
            return DockerHost.defaultPort();
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return DockerHost.defaultPort();
        }
    }

    public static String defaultCertPath() {
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, ".docker").toString();
    }

    public static String certPathFromEnv() {
        return System.getenv("DOCKER_CERT_PATH");
    }

    public static String configPathFromEnv() {
        return System.getenv("DOCKER_CONFIG");
    }
}

