/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverCreator {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;

    public WebDriverCreator(Config config) {
        this.config = config;
    }

    public WebDriver createRemoteWebDriver(URL hubUrl, Capabilities capabilities) {
        RemoteWebDriver webdriver = null;
        int waitTimeoutSec = this.getConfig().getRemoteWebdriverWaitTimeoutSec();
        int pollTimeSec = this.getConfig().getRemoteWebdriverPollTimeSec();
        long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(waitTimeoutSec);
        do {
            if (System.currentTimeMillis() > timeoutMs) {
                throw new SeleniumJupiterException("Timeout of " + waitTimeoutSec + "  seconds creating WebDriver object");
            }
            try {
                String browserName = capabilities.getBrowserName().toUpperCase();
                this.log.debug("Creating WebDriver for {} at {} with {}", new Object[]{browserName, hubUrl, capabilities});
                webdriver = new RemoteWebDriver(hubUrl, capabilities);
            }
            catch (Exception e1) {
                try {
                    this.log.warn("{} creating WebDriver object ({})", (Object)e1.getClass().getSimpleName(), (Object)e1.getMessage());
                    Thread.sleep(TimeUnit.SECONDS.toMillis(pollTimeSec));
                }
                catch (InterruptedException e2) {
                    this.log.warn("Interrupted exception creating WebDriver object", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
            }
        } while (webdriver == null);
        this.log.trace("Created WebDriver object (session id {})", (Object)((RemoteWebDriver)webdriver).getSessionId());
        return webdriver;
    }

    public Config getConfig() {
        return this.config;
    }
}

