/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.DockerHubApi;
import io.github.bonigarcia.seljup.DockerHubTags;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.Config;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class DockerHubService {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Long PAGE_SIZE = 1024L;
    DockerHubApi dockerHubApi;

    public DockerHubService(Config config) {
        String dockerHubUrl = config.getDockerHubUrl();
        OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl(dockerHubUrl).build();
        this.dockerHubApi = (DockerHubApi)retrofit.create(DockerHubApi.class);
    }

    public List<DockerHubTags.DockerHubTag> listTags() throws IOException {
        Response listTagsResponse;
        this.log.info("Getting browser image list from Docker Hub");
        long page = 0L;
        ArrayList<DockerHubTags.DockerHubTag> results = new ArrayList<DockerHubTags.DockerHubTag>();
        do {
            Response response = listTagsResponse = ++page > 1L ? this.dockerHubApi.listTagsNext(page, PAGE_SIZE).execute() : this.dockerHubApi.listTags(PAGE_SIZE).execute();
            if (!listTagsResponse.isSuccessful()) {
                String errorBody = listTagsResponse.errorBody().string();
                throw new SeleniumJupiterException(errorBody);
            }
            results.addAll(((DockerHubTags)listTagsResponse.body()).getResults());
        } while (((DockerHubTags)listTagsResponse.body()).next != null);
        return results;
    }
}

