/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import org.treesitter.AnonymousLanguage;
import org.treesitter.CleanerRunner;
import org.treesitter.TSInputEdit;
import org.treesitter.TSInputEncoding;
import org.treesitter.TSLanguage;
import org.treesitter.TSLogger;
import org.treesitter.TSNode;
import org.treesitter.TSPoint;
import org.treesitter.TSQueryMatch;
import org.treesitter.TSQueryPredicateStep;
import org.treesitter.TSRange;
import org.treesitter.TSReader;
import org.treesitter.TSTree;
import org.treesitter.utils.NativeUtils;

public class TSParser {
    public static final int TREE_SITTER_LANGUAGE_VERSION = 14;
    public static final int TREE_SITTER_MIN_COMPATIBLE_LANGUAGE_VERSION = 13;
    private TSLanguage language;
    private final long ptr = TSParser.ts_parser_new();
    private TSLogger logger;

    public static native long ts_parser_new();

    public static native void ts_parser_delete(long var0);

    private static native boolean ts_parser_set_language(long var0, long var2);

    private static native long ts_parser_language(long var0);

    private static native boolean ts_parser_set_included_ranges(long var0, TSRange[] var2);

    private static native TSRange[] ts_parser_included_ranges(long var0);

    private static native long ts_parser_parse(long var0, byte[] var2, long var3, TSReader var5, int var6);

    private static native long ts_parser_parse_string(long var0, long var2, String var4);

    private static native long ts_parser_parse_string_encoding(long var0, long var2, String var4, int var5);

    private static native void ts_parser_reset(long var0);

    private static native void ts_parser_set_timeout_micros(long var0, long var2);

    private static native long ts_parser_timeout_micros(long var0);

    private static native void ts_parser_set_cancellation_flag(long var0, long var2);

    private static native long ts_parser_cancellation_flag(long var0);

    private static native long alloc_cancellation_flag();

    private static native long get_cancellation_flag_value(long var0);

    private static native void free_cancellation_flag(long var0);

    private static native void write_cancellation_flag(long var0, long var2);

    private static native void ts_parser_set_logger(long var0, TSLogger var2);

    private static native void free_logger(long var0);

    private static native void ts_parser_print_dot_graphs(long var0, FileDescriptor var2);

    protected static native long ts_tree_copy(long var0);

    protected static native void ts_tree_delete(long var0);

    protected static native TSNode ts_tree_root_node(long var0);

    protected static native TSNode ts_tree_root_node_with_offset(long var0, int var2, TSPoint var3);

    protected static native long ts_tree_language(long var0);

    protected static native TSRange[] ts_tree_included_ranges(long var0);

    protected static native void ts_tree_edit(long var0, TSInputEdit var2);

    protected static native TSRange[] ts_tree_get_changed_ranges(long var0, long var2);

    protected static native String ts_node_type(TSNode var0);

    protected static native int ts_node_symbol(TSNode var0);

    protected static native String ts_node_grammar_type(TSNode var0);

    protected static native int ts_node_grammar_symbol(TSNode var0);

    protected static native int ts_node_start_byte(TSNode var0);

    protected static native TSPoint ts_node_start_point(TSNode var0);

    protected static native int ts_node_end_byte(TSNode var0);

    protected static native TSPoint ts_node_end_point(TSNode var0);

    protected static native String ts_node_string(TSNode var0);

    protected static native boolean ts_node_is_null(TSNode var0);

    protected static native boolean ts_node_is_named(TSNode var0);

    protected static native boolean ts_node_is_missing(TSNode var0);

    protected static native boolean ts_node_is_extra(TSNode var0);

    protected static native boolean ts_node_has_changes(TSNode var0);

    protected static native boolean ts_node_has_error(TSNode var0);

    protected static native boolean ts_node_is_error(TSNode var0);

    protected static native int ts_node_parse_state(TSNode var0);

    protected static native int ts_node_next_parse_state(TSNode var0);

    protected static native TSNode ts_node_parent(TSNode var0);

    protected static native TSNode ts_node_child(TSNode var0, int var1);

    protected static native String ts_node_field_name_for_child(TSNode var0, int var1);

    protected static native int ts_node_child_count(TSNode var0);

    protected static native TSNode ts_node_named_child(TSNode var0, int var1);

    protected static native int ts_node_named_child_count(TSNode var0);

    protected static native TSNode ts_node_child_by_field_name(TSNode var0, String var1);

    protected static native TSNode ts_node_child_by_field_id(TSNode var0, int var1);

    protected static native TSNode ts_node_next_sibling(TSNode var0);

    protected static native TSNode ts_node_prev_sibling(TSNode var0);

    protected static native TSNode ts_node_next_named_sibling(TSNode var0);

    protected static native TSNode ts_node_prev_named_sibling(TSNode var0);

    protected static native TSNode ts_node_first_child_for_byte(TSNode var0, int var1);

    protected static native TSNode ts_node_first_named_child_for_byte(TSNode var0, int var1);

    protected static native TSNode ts_node_descendant_for_byte_range(TSNode var0, int var1, int var2);

    protected static native TSNode ts_node_descendant_for_point_range(TSNode var0, TSPoint var1, TSPoint var2);

    protected static native TSNode ts_node_named_descendant_for_byte_range(TSNode var0, int var1, int var2);

    protected static native TSNode ts_node_named_descendant_for_point_range(TSNode var0, TSPoint var1, TSPoint var2);

    protected static native TSNode ts_node_edit(TSNode var0, TSInputEdit var1);

    protected static native boolean ts_node_eq(TSNode var0, TSNode var1);

    protected static native void free_cursor(long var0);

    protected static native long ts_tree_cursor_new(TSNode var0);

    protected static native void ts_tree_cursor_delete(long var0);

    protected static native void ts_tree_cursor_reset(long var0, TSNode var2);

    protected static native TSNode ts_tree_cursor_current_node(long var0);

    protected static native String ts_tree_cursor_current_field_name(long var0);

    protected static native int ts_tree_cursor_current_field_id(long var0);

    protected static native boolean ts_tree_cursor_goto_parent(long var0);

    protected static native boolean ts_tree_cursor_goto_next_sibling(long var0);

    protected static native boolean ts_tree_cursor_goto_first_child(long var0);

    protected static native int ts_tree_cursor_goto_first_child_for_byte(long var0, int var2);

    protected static native int ts_tree_cursor_goto_first_child_for_point(long var0, TSPoint var2);

    protected static native long ts_tree_cursor_copy(long var0);

    protected static native long ts_query_new(long var0, String var2);

    protected static native void ts_query_delete(long var0);

    protected static native int ts_query_pattern_count(long var0);

    protected static native int ts_query_capture_count(long var0);

    protected static native int ts_query_string_count(long var0);

    protected static native int ts_query_start_byte_for_pattern(long var0, int var2);

    protected static native TSQueryPredicateStep[] ts_query_predicates_for_pattern(long var0, int var2);

    protected static native boolean ts_query_is_pattern_rooted(long var0, int var2);

    protected static native boolean ts_query_is_pattern_non_local(long var0, int var2);

    protected static native boolean ts_query_is_pattern_guaranteed_at_step(long var0, int var2);

    protected static native String ts_query_capture_name_for_id(long var0, int var2);

    protected static native int ts_query_capture_quantifier_for_id(long var0, int var2, int var3);

    protected static native String ts_query_string_value_for_id(long var0, int var2);

    protected static native void ts_query_disable_capture(long var0, String var2);

    protected static native void ts_query_disable_pattern(long var0, int var2);

    protected static native long ts_query_cursor_new();

    protected static native void ts_query_cursor_delete(long var0);

    protected static native void ts_query_cursor_exec(long var0, long var2, TSNode var4);

    protected static native boolean ts_query_cursor_did_exceed_match_limit(long var0);

    protected static native int ts_query_cursor_match_limit(long var0);

    protected static native void ts_query_cursor_set_match_limit(long var0, int var2);

    protected static native void ts_query_cursor_set_byte_range(long var0, int var2, int var3);

    protected static native void ts_query_cursor_set_point_range(long var0, TSPoint var2, TSPoint var3);

    protected static native boolean ts_query_cursor_next_match(long var0, TSQueryMatch var2);

    protected static native void ts_query_cursor_remove_match(long var0, int var2);

    protected static native boolean ts_query_cursor_next_capture(long var0, TSQueryMatch var2);

    protected static native void ts_tree_print_dot_graph(long var0, FileDescriptor var2);

    protected static native long ts_language_copy(long var0);

    protected static native void ts_language_delete(long var0);

    protected static native int ts_language_state_count(long var0);

    protected static native int ts_language_next_state(long var0, int var2, int var3);

    protected static native int ts_language_field_count(long var0);

    protected static native String ts_language_field_name_for_id(long var0, int var2);

    protected static native int ts_language_field_id_for_name(long var0, String var2);

    protected static native int ts_language_symbol_type(long var0, int var2);

    protected static native int ts_language_symbol_count(long var0);

    protected static native String ts_language_symbol_name(long var0, int var2);

    protected static native int ts_language_symbol_for_name(long var0, String var2, boolean var3);

    protected static native int ts_language_version(long var0);

    protected static native long ts_lookahead_iterator_new(long var0, int var2);

    protected static native void ts_lookahead_iterator_delete(long var0);

    protected static native boolean ts_lookahead_iterator_reset_state(long var0, int var2);

    protected static native boolean ts_lookahead_iterator_reset(long var0, long var2, int var4);

    protected static native long ts_lookahead_iterator_language(long var0);

    protected static native boolean ts_lookahead_iterator_next(long var0);

    protected static native int ts_lookahead_iterator_current_symbol(long var0);

    protected static native String ts_lookahead_iterator_current_symbol_name(long var0);

    public TSParser() {
        long cancellationFlagPtr = TSParser.alloc_cancellation_flag();
        TSParser.write_cancellation_flag(cancellationFlagPtr, 0L);
        TSParser.ts_parser_set_cancellation_flag(this.ptr, cancellationFlagPtr);
        CleanerRunner.register(this, new TSParserCleanAction(this.ptr));
    }

    public TSLogger getLogger() {
        return this.logger;
    }

    public void setLogger(TSLogger logger) {
        this.logger = logger;
        TSParser.ts_parser_set_logger(this.ptr, logger);
    }

    public boolean setLanguage(TSLanguage language) {
        this.language = language;
        return TSParser.ts_parser_set_language(this.ptr, language.getPtr());
    }

    public TSTree parseString(TSTree oldTree, String input) {
        long oldTreePtr = oldTree == null ? 0L : oldTree.getPtr();
        long treePtr = TSParser.ts_parser_parse_string(this.ptr, oldTreePtr, input);
        return new TSTree(treePtr);
    }

    public TSTree parseStringEncoding(TSTree oldTree, String input, TSInputEncoding encoding) {
        long oldTreePtr = oldTree == null ? 0L : oldTree.getPtr();
        long treePtr = TSParser.ts_parser_parse_string_encoding(this.ptr, oldTreePtr, input, encoding.ordinal());
        return new TSTree(treePtr);
    }

    public TSTree parse(byte[] buf, TSTree oldTree, TSReader reader, TSInputEncoding encoding) {
        long oldTreePtr = oldTree == null ? 0L : oldTree.getPtr();
        long treePtr = TSParser.ts_parser_parse(this.ptr, buf, oldTreePtr, reader, encoding.ordinal());
        if (treePtr == 0L) {
            return null;
        }
        return new TSTree(treePtr);
    }

    public TSLanguage getLanguage() {
        return new AnonymousLanguage(TSParser.ts_parser_language(this.ptr));
    }

    public boolean setIncludedRanges(TSRange[] ranges) {
        return TSParser.ts_parser_set_included_ranges(this.ptr, ranges);
    }

    public TSRange[] getIncludedRanges() {
        return TSParser.ts_parser_included_ranges(this.ptr);
    }

    public void reset() {
        TSParser.ts_parser_reset(this.ptr);
    }

    public void setTimeoutMicros(long timeoutMicros) {
        TSParser.ts_parser_set_timeout_micros(this.ptr, timeoutMicros);
    }

    public long getTimeoutMicros() {
        return TSParser.ts_parser_timeout_micros(this.ptr);
    }

    public void setCancellationFlag(long flag) {
        TSParser.write_cancellation_flag(TSParser.ts_parser_cancellation_flag(this.ptr), flag);
    }

    public long getCancellationFlag() {
        return TSParser.get_cancellation_flag_value(TSParser.ts_parser_cancellation_flag(this.ptr));
    }

    public void printDotGraphs(File file) throws IOException {
        if (file == null) {
            TSParser.ts_parser_print_dot_graphs(this.ptr, null);
            return;
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        TSParser.ts_parser_print_dot_graphs(this.ptr, outputStream.getFD());
    }

    static {
        NativeUtils.loadLib("lib/tree-sitter");
    }

    private static class TSParserCleanAction
    implements Runnable {
        private final long ptr;

        public TSParserCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            long flagPtr = TSParser.ts_parser_cancellation_flag(this.ptr);
            if (flagPtr != 0L) {
                TSParser.free_cancellation_flag(flagPtr);
            }
            TSParser.free_logger(this.ptr);
            TSParser.ts_parser_delete(this.ptr);
        }
    }
}

