/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.stream.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum WindowSize {
    WINDOW_SIZE_1h("1h"),
    WINDOW_SIZE_4h("4h"),
    WINDOW_SIZE_1d("1d");

    private String value;

    private WindowSize(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WindowSize fromValue(String value) {
        for (WindowSize b : WindowSize.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        WindowSize.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<WindowSize> {
        public void write(JsonWriter jsonWriter, WindowSize enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public WindowSize read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return WindowSize.fromValue(value);
        }
    }
}

