/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum SymbolStatus {
    TRADING("TRADING"),
    END_OF_DAY("END_OF_DAY"),
    HALT("HALT"),
    BREAK("BREAK"),
    NON_REPRESENTABLE("NON_REPRESENTABLE");

    private String value;

    private SymbolStatus(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SymbolStatus fromValue(String value) {
        for (SymbolStatus b : SymbolStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        SymbolStatus.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<SymbolStatus> {
        public void write(JsonWriter jsonWriter, SymbolStatus enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public SymbolStatus read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return SymbolStatus.fromValue(value);
        }
    }
}

