/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersCancelAllRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersCancelAllResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendKeepPriorityRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendKeepPriorityResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelReplaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelReplaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListCancelRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListCancelResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOcoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOcoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtocoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtocoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderTestRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderTestResponse;
import com.binance.connector.client.spot.websocket.api.model.SorOrderPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.SorOrderPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.SorOrderTestRequest;
import com.binance.connector.client.spot.websocket.api.model.SorOrderTestResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class TradeApi {
    private ConnectionInterface connection;

    public TradeApi() {
    }

    public TradeApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<OpenOrdersCancelAllResponse> openOrdersCancelAll(OpenOrdersCancelAllRequest openOrdersCancelAllRequest) throws ApiException {
        this.openOrdersCancelAllValidateBeforeCall(openOrdersCancelAllRequest);
        String methodName = "/openOrders.cancelAll".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)openOrdersCancelAllRequest).responseType(OpenOrdersCancelAllResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void openOrdersCancelAllValidateBeforeCall(OpenOrdersCancelAllRequest openOrdersCancelAllRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)openOrdersCancelAllRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderAmendKeepPriorityResponse> orderAmendKeepPriority(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        this.orderAmendKeepPriorityValidateBeforeCall(orderAmendKeepPriorityRequest);
        String methodName = "/order.amend.keepPriority".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderAmendKeepPriorityRequest).responseType(OrderAmendKeepPriorityResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderAmendKeepPriorityValidateBeforeCall(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderAmendKeepPriorityRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderCancelResponse> orderCancel(OrderCancelRequest orderCancelRequest) throws ApiException {
        this.orderCancelValidateBeforeCall(orderCancelRequest);
        String methodName = "/order.cancel".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderCancelRequest).responseType(OrderCancelResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderCancelValidateBeforeCall(OrderCancelRequest orderCancelRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderCancelRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderCancelReplaceResponse> orderCancelReplace(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        this.orderCancelReplaceValidateBeforeCall(orderCancelReplaceRequest);
        String methodName = "/order.cancelReplace".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderCancelReplaceRequest).responseType(OrderCancelReplaceResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderCancelReplaceValidateBeforeCall(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderCancelReplaceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListCancelResponse> orderListCancel(OrderListCancelRequest orderListCancelRequest) throws ApiException {
        this.orderListCancelValidateBeforeCall(orderListCancelRequest);
        String methodName = "/orderList.cancel".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListCancelRequest).responseType(OrderListCancelResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListCancelValidateBeforeCall(OrderListCancelRequest orderListCancelRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListCancelRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListPlaceResponse> orderListPlace(OrderListPlaceRequest orderListPlaceRequest) throws ApiException {
        this.orderListPlaceValidateBeforeCall(orderListPlaceRequest);
        String methodName = "/orderList.place".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListPlaceRequest).responseType(OrderListPlaceResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListPlaceValidateBeforeCall(OrderListPlaceRequest orderListPlaceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListPlaceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListPlaceOcoResponse> orderListPlaceOco(OrderListPlaceOcoRequest orderListPlaceOcoRequest) throws ApiException {
        this.orderListPlaceOcoValidateBeforeCall(orderListPlaceOcoRequest);
        String methodName = "/orderList.place.oco".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListPlaceOcoRequest).responseType(OrderListPlaceOcoResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListPlaceOcoValidateBeforeCall(OrderListPlaceOcoRequest orderListPlaceOcoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListPlaceOcoRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListPlaceOtoResponse> orderListPlaceOto(OrderListPlaceOtoRequest orderListPlaceOtoRequest) throws ApiException {
        this.orderListPlaceOtoValidateBeforeCall(orderListPlaceOtoRequest);
        String methodName = "/orderList.place.oto".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListPlaceOtoRequest).responseType(OrderListPlaceOtoResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListPlaceOtoValidateBeforeCall(OrderListPlaceOtoRequest orderListPlaceOtoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListPlaceOtoRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListPlaceOtocoResponse> orderListPlaceOtoco(OrderListPlaceOtocoRequest orderListPlaceOtocoRequest) throws ApiException {
        this.orderListPlaceOtocoValidateBeforeCall(orderListPlaceOtocoRequest);
        String methodName = "/orderList.place.otoco".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListPlaceOtocoRequest).responseType(OrderListPlaceOtocoResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListPlaceOtocoValidateBeforeCall(OrderListPlaceOtocoRequest orderListPlaceOtocoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListPlaceOtocoRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderPlaceResponse> orderPlace(OrderPlaceRequest orderPlaceRequest) throws ApiException {
        this.orderPlaceValidateBeforeCall(orderPlaceRequest);
        String methodName = "/order.place".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderPlaceRequest).responseType(OrderPlaceResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderPlaceValidateBeforeCall(OrderPlaceRequest orderPlaceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderPlaceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderTestResponse> orderTest(OrderTestRequest orderTestRequest) throws ApiException {
        this.orderTestValidateBeforeCall(orderTestRequest);
        String methodName = "/order.test".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderTestRequest).responseType(OrderTestResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderTestValidateBeforeCall(OrderTestRequest orderTestRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderTestRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<SorOrderPlaceResponse> sorOrderPlace(SorOrderPlaceRequest sorOrderPlaceRequest) throws ApiException {
        this.sorOrderPlaceValidateBeforeCall(sorOrderPlaceRequest);
        String methodName = "/sor.order.place".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)sorOrderPlaceRequest).responseType(SorOrderPlaceResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sorOrderPlaceValidateBeforeCall(SorOrderPlaceRequest sorOrderPlaceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)sorOrderPlaceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<SorOrderTestResponse> sorOrderTest(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        this.sorOrderTestValidateBeforeCall(sorOrderTestRequest);
        String methodName = "/sor.order.test".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)sorOrderTestRequest).responseType(SorOrderTestResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sorOrderTestValidateBeforeCall(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)sorOrderTestRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

