/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.spot.websocket.api.model.ExchangeInfoRequest;
import com.binance.connector.client.spot.websocket.api.model.ExchangeInfoResponse;
import com.binance.connector.client.spot.websocket.api.model.PingResponse;
import com.binance.connector.client.spot.websocket.api.model.TimeResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class GeneralApi {
    private ConnectionInterface connection;

    public GeneralApi() {
    }

    public GeneralApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<ExchangeInfoResponse> exchangeInfo(ExchangeInfoRequest exchangeInfoRequest) throws ApiException {
        this.exchangeInfoValidateBeforeCall(exchangeInfoRequest);
        String methodName = "/exchangeInfo".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)exchangeInfoRequest).responseType(ExchangeInfoResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void exchangeInfoValidateBeforeCall(ExchangeInfoRequest exchangeInfoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)exchangeInfoRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<PingResponse> ping() throws ApiException {
        this.pingValidateBeforeCall();
        String methodName = "/ping".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(PingResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void pingValidateBeforeCall() throws ApiException {
    }

    public CompletableFuture<TimeResponse> time() throws ApiException {
        this.timeValidateBeforeCall();
        String methodName = "/time".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(TimeResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void timeValidateBeforeCall() throws ApiException {
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

