/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.spot.websocket.api.model.SessionLogonRequest;
import com.binance.connector.client.spot.websocket.api.model.SessionLogonResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionLogoutResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionStatusResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class AuthApi {
    private ConnectionInterface connection;

    public AuthApi() {
    }

    public AuthApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<SessionLogonResponse> sessionLogon(SessionLogonRequest sessionLogonRequest) throws ApiException {
        this.sessionLogonValidateBeforeCall(sessionLogonRequest);
        String methodName = "/session.logon".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)sessionLogonRequest).responseType(SessionLogonResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sessionLogonValidateBeforeCall(SessionLogonRequest sessionLogonRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)sessionLogonRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<SessionLogoutResponse> sessionLogout() throws ApiException {
        this.sessionLogoutValidateBeforeCall();
        String methodName = "/session.logout".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(SessionLogoutResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sessionLogoutValidateBeforeCall() throws ApiException {
    }

    public CompletableFuture<SessionStatusResponse> sessionStatus() throws ApiException {
        this.sessionStatusValidateBeforeCall();
        String methodName = "/session.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(SessionStatusResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sessionStatusValidateBeforeCall() throws ApiException {
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

