/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.spot.websocket.api.model.AccountCommissionRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountCommissionResponse;
import com.binance.connector.client.spot.websocket.api.model.AccountRateLimitsOrdersRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountRateLimitsOrdersResponse;
import com.binance.connector.client.spot.websocket.api.model.AccountStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.AllOrderListsRequest;
import com.binance.connector.client.spot.websocket.api.model.AllOrderListsResponse;
import com.binance.connector.client.spot.websocket.api.model.AllOrdersRequest;
import com.binance.connector.client.spot.websocket.api.model.AllOrdersResponse;
import com.binance.connector.client.spot.websocket.api.model.MyAllocationsRequest;
import com.binance.connector.client.spot.websocket.api.model.MyAllocationsResponse;
import com.binance.connector.client.spot.websocket.api.model.MyPreventedMatchesRequest;
import com.binance.connector.client.spot.websocket.api.model.MyPreventedMatchesResponse;
import com.binance.connector.client.spot.websocket.api.model.MyTradesRequest;
import com.binance.connector.client.spot.websocket.api.model.MyTradesResponse;
import com.binance.connector.client.spot.websocket.api.model.OpenOrderListsStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrderListsStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendmentsRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendmentsResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderStatusResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class AccountApi {
    private ConnectionInterface connection;

    public AccountApi() {
    }

    public AccountApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<AccountCommissionResponse> accountCommission(AccountCommissionRequest accountCommissionRequest) throws ApiException {
        this.accountCommissionValidateBeforeCall(accountCommissionRequest);
        String methodName = "/account.commission".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)accountCommissionRequest).responseType(AccountCommissionResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void accountCommissionValidateBeforeCall(AccountCommissionRequest accountCommissionRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)accountCommissionRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<AccountRateLimitsOrdersResponse> accountRateLimitsOrders(AccountRateLimitsOrdersRequest accountRateLimitsOrdersRequest) throws ApiException {
        this.accountRateLimitsOrdersValidateBeforeCall(accountRateLimitsOrdersRequest);
        String methodName = "/account.rateLimits.orders".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)accountRateLimitsOrdersRequest).responseType(AccountRateLimitsOrdersResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void accountRateLimitsOrdersValidateBeforeCall(AccountRateLimitsOrdersRequest accountRateLimitsOrdersRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)accountRateLimitsOrdersRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<AccountStatusResponse> accountStatus(AccountStatusRequest accountStatusRequest) throws ApiException {
        this.accountStatusValidateBeforeCall(accountStatusRequest);
        String methodName = "/account.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)accountStatusRequest).responseType(AccountStatusResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void accountStatusValidateBeforeCall(AccountStatusRequest accountStatusRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)accountStatusRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<AllOrderListsResponse> allOrderLists(AllOrderListsRequest allOrderListsRequest) throws ApiException {
        this.allOrderListsValidateBeforeCall(allOrderListsRequest);
        String methodName = "/allOrderLists".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)allOrderListsRequest).responseType(AllOrderListsResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void allOrderListsValidateBeforeCall(AllOrderListsRequest allOrderListsRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)allOrderListsRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<AllOrdersResponse> allOrders(AllOrdersRequest allOrdersRequest) throws ApiException {
        this.allOrdersValidateBeforeCall(allOrdersRequest);
        String methodName = "/allOrders".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)allOrdersRequest).responseType(AllOrdersResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void allOrdersValidateBeforeCall(AllOrdersRequest allOrdersRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)allOrdersRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<MyAllocationsResponse> myAllocations(MyAllocationsRequest myAllocationsRequest) throws ApiException {
        this.myAllocationsValidateBeforeCall(myAllocationsRequest);
        String methodName = "/myAllocations".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)myAllocationsRequest).responseType(MyAllocationsResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void myAllocationsValidateBeforeCall(MyAllocationsRequest myAllocationsRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)myAllocationsRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<MyPreventedMatchesResponse> myPreventedMatches(MyPreventedMatchesRequest myPreventedMatchesRequest) throws ApiException {
        this.myPreventedMatchesValidateBeforeCall(myPreventedMatchesRequest);
        String methodName = "/myPreventedMatches".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)myPreventedMatchesRequest).responseType(MyPreventedMatchesResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void myPreventedMatchesValidateBeforeCall(MyPreventedMatchesRequest myPreventedMatchesRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)myPreventedMatchesRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<MyTradesResponse> myTrades(MyTradesRequest myTradesRequest) throws ApiException {
        this.myTradesValidateBeforeCall(myTradesRequest);
        String methodName = "/myTrades".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)myTradesRequest).responseType(MyTradesResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void myTradesValidateBeforeCall(MyTradesRequest myTradesRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)myTradesRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OpenOrderListsStatusResponse> openOrderListsStatus(OpenOrderListsStatusRequest openOrderListsStatusRequest) throws ApiException {
        this.openOrderListsStatusValidateBeforeCall(openOrderListsStatusRequest);
        String methodName = "/openOrderLists.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)openOrderListsStatusRequest).responseType(OpenOrderListsStatusResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void openOrderListsStatusValidateBeforeCall(OpenOrderListsStatusRequest openOrderListsStatusRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)openOrderListsStatusRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OpenOrdersStatusResponse> openOrdersStatus(OpenOrdersStatusRequest openOrdersStatusRequest) throws ApiException {
        this.openOrdersStatusValidateBeforeCall(openOrdersStatusRequest);
        String methodName = "/openOrders.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)openOrdersStatusRequest).responseType(OpenOrdersStatusResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void openOrdersStatusValidateBeforeCall(OpenOrdersStatusRequest openOrdersStatusRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)openOrdersStatusRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderAmendmentsResponse> orderAmendments(OrderAmendmentsRequest orderAmendmentsRequest) throws ApiException {
        this.orderAmendmentsValidateBeforeCall(orderAmendmentsRequest);
        String methodName = "/order.amendments".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderAmendmentsRequest).responseType(OrderAmendmentsResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderAmendmentsValidateBeforeCall(OrderAmendmentsRequest orderAmendmentsRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderAmendmentsRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderListStatusResponse> orderListStatus(OrderListStatusRequest orderListStatusRequest) throws ApiException {
        this.orderListStatusValidateBeforeCall(orderListStatusRequest);
        String methodName = "/orderList.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderListStatusRequest).responseType(OrderListStatusResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderListStatusValidateBeforeCall(OrderListStatusRequest orderListStatusRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderListStatusRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<OrderStatusResponse> orderStatus(OrderStatusRequest orderStatusRequest) throws ApiException {
        this.orderStatusValidateBeforeCall(orderStatusRequest);
        String methodName = "/order.status".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)orderStatusRequest).responseType(OrderStatusResponse.class).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void orderStatusValidateBeforeCall(OrderStatusRequest orderStatusRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)orderStatusRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

