/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OrderType {
    MARKET("MARKET"),
    LIMIT("LIMIT"),
    STOP_LOSS("STOP_LOSS"),
    STOP_LOSS_LIMIT("STOP_LOSS_LIMIT"),
    TAKE_PROFIT("TAKE_PROFIT"),
    TAKE_PROFIT_LIMIT("TAKE_PROFIT_LIMIT"),
    LIMIT_MAKER("LIMIT_MAKER"),
    NON_REPRESENTABLE("NON_REPRESENTABLE");

    private String value;

    private OrderType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderType fromValue(String value) {
        for (OrderType b : OrderType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OrderType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OrderType> {
        public void write(JsonWriter jsonWriter, OrderType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderType.fromValue(value);
        }
    }
}

