/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.model;

import com.binance.connector.client.spot.rest.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DepthResponse {
    public static final String SERIALIZED_NAME_LAST_UPDATE_ID = "lastUpdateId";
    @SerializedName(value="lastUpdateId")
    @Nullable
    private Long lastUpdateId;
    public static final String SERIALIZED_NAME_BIDS = "bids";
    @SerializedName(value="bids")
    @Nullable
    private List<List<String>> bids;
    public static final String SERIALIZED_NAME_ASKS = "asks";
    @SerializedName(value="asks")
    @Nullable
    private List<List<String>> asks;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DepthResponse lastUpdateId(@Nullable Long lastUpdateId) {
        this.lastUpdateId = lastUpdateId;
        return this;
    }

    @Nullable
    public Long getLastUpdateId() {
        return this.lastUpdateId;
    }

    public void setLastUpdateId(@Nullable Long lastUpdateId) {
        this.lastUpdateId = lastUpdateId;
    }

    public DepthResponse bids(@Nullable List<List<String>> bids) {
        this.bids = bids;
        return this;
    }

    public DepthResponse addBidsItem(List<String> bidsItem) {
        if (this.bids == null) {
            this.bids = new ArrayList<List<String>>();
        }
        this.bids.add(bidsItem);
        return this;
    }

    @Nullable
    @Valid
    public List<List<String>> getBids() {
        return this.bids;
    }

    public void setBids(@Nullable List<List<String>> bids) {
        this.bids = bids;
    }

    public DepthResponse asks(@Nullable List<List<String>> asks) {
        this.asks = asks;
        return this;
    }

    public DepthResponse addAsksItem(List<String> asksItem) {
        if (this.asks == null) {
            this.asks = new ArrayList<List<String>>();
        }
        this.asks.add(asksItem);
        return this;
    }

    @Nullable
    @Valid
    public List<List<String>> getAsks() {
        return this.asks;
    }

    public void setAsks(@Nullable List<List<String>> asks) {
        this.asks = asks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepthResponse depthResponse = (DepthResponse)o;
        return Objects.equals(this.lastUpdateId, depthResponse.lastUpdateId) && Objects.equals(this.bids, depthResponse.bids) && Objects.equals(this.asks, depthResponse.asks);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdateId, this.bids, this.asks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepthResponse {\n");
        sb.append("\t\tlastUpdateId: ").append(this.toIndentedString(this.lastUpdateId)).append("\n");
        sb.append("\t\tbids: ").append(this.toIndentedString(this.bids)).append("\n");
        sb.append("\t\tasks: ").append(this.toIndentedString(this.asks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        StringBuilder sb = new StringBuilder();
        Long lastUpdateIdValue = this.getLastUpdateId();
        String lastUpdateIdValueAsString = "";
        lastUpdateIdValueAsString = ((Object)lastUpdateIdValue).toString();
        sb.append("lastUpdateId=").append(DepthResponse.urlEncode(lastUpdateIdValueAsString)).append("");
        List<List<String>> bidsValue = this.getBids();
        String bidsValueAsString = "";
        bidsValueAsString = ((Collection)bidsValue).stream().map(Object::toString).collect(Collectors.joining(","));
        sb.append("bids=").append(DepthResponse.urlEncode(bidsValueAsString)).append("");
        List<List<String>> asksValue = this.getAsks();
        String asksValueAsString = "";
        asksValueAsString = ((Collection)asksValue).stream().map(Object::toString).collect(Collectors.joining(","));
        sb.append("asks=").append(DepthResponse.urlEncode(asksValueAsString)).append("");
        return sb.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StandardCharsets.UTF_8.name() + " is unsupported", e);
        }
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DepthResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BIDS) != null && !jsonObj.get(SERIALIZED_NAME_BIDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BIDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASKS) != null && !jsonObj.get(SERIALIZED_NAME_ASKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ASKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `asks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASKS).toString()));
        }
    }

    public static DepthResponse fromJson(String jsonString) throws IOException {
        return (DepthResponse)JSON.getGson().fromJson(jsonString, DepthResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAST_UPDATE_ID);
        openapiFields.add(SERIALIZED_NAME_BIDS);
        openapiFields.add(SERIALIZED_NAME_ASKS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DepthResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DepthResponse.class));
            return new TypeAdapter<DepthResponse>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, DepthResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DepthResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (DepthResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

