/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.spot.rest.model.NewUserDataStreamResponse;
import com.binance.connector.client.spot.rest.model.PutUserDataStreamRequest;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import okhttp3.Call;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class UserDataStreamApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private static final boolean HAS_TIME_UNIT = true;

    public UserDataStreamApi(ClientConfiguration clientConfiguration) {
        this(new ApiClient(clientConfiguration));
    }

    public UserDataStreamApi(ApiClient apiClient) {
        apiClient.setUserAgent(USER_AGENT);
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteUserDataStreamCall(String listenKey) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/userDataStream";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (listenKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listenKey", (Object)listenKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceApiKeyOnly");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call deleteUserDataStreamValidateBeforeCall(String listenKey) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{listenKey};
            Method method = this.getClass().getMethod("deleteUserDataStream", String.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.deleteUserDataStreamCall(listenKey);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<Void> deleteUserDataStream(@NotNull String listenKey) throws ApiException {
        Call localVarCall = this.deleteUserDataStreamValidateBeforeCall(listenKey);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call newUserDataStreamCall() throws ApiException {
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/userDataStream";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceApiKeyOnly");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call newUserDataStreamValidateBeforeCall() throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{};
            Method method = this.getClass().getMethod("newUserDataStream", new Class[0]);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.newUserDataStreamCall();
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<NewUserDataStreamResponse> newUserDataStream() throws ApiException {
        Call localVarCall = this.newUserDataStreamValidateBeforeCall();
        Type localVarReturnType = new TypeToken<NewUserDataStreamResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call putUserDataStreamCall(PutUserDataStreamRequest putUserDataStreamRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/userDataStream";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, String> localVarFormParams = new HashMap<String, String>();
        if (putUserDataStreamRequest.getListenKey() != null) {
            localVarFormParams.put("listenKey", putUserDataStreamRequest.getListenKey());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceApiKeyOnly");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call putUserDataStreamValidateBeforeCall(PutUserDataStreamRequest putUserDataStreamRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{putUserDataStreamRequest};
            Method method = this.getClass().getMethod("putUserDataStream", PutUserDataStreamRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.putUserDataStreamCall(putUserDataStreamRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<Void> putUserDataStream(@Valid @NotNull PutUserDataStreamRequest putUserDataStreamRequest) throws ApiException {
        Call localVarCall = this.putUserDataStreamValidateBeforeCall(putUserDataStreamRequest);
        return this.localVarApiClient.execute(localVarCall);
    }
}

