/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.dtos;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;

public class RequestWrapperDTO<T, U> {
    protected String id;
    protected T params;
    protected String method;
    protected transient Type responseType;
    protected transient CompletableFuture<U> responseCallback = new CompletableFuture();

    public RequestWrapperDTO() {
    }

    public RequestWrapperDTO(String id, T params, String method) {
        this.id = id;
        this.params = params;
        this.method = method;
    }

    public String getId() {
        return this.id;
    }

    public T getParams() {
        return this.params;
    }

    public String getMethod() {
        return this.method;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Type responseType) {
        this.responseType = responseType;
    }

    private RequestWrapperDTO(Builder<T, U> builder) {
        this.id = builder.id;
        this.params = builder.params;
        this.method = builder.method;
        this.responseType = builder.responseType;
    }

    public CompletableFuture<U> getResponseCallback() {
        return this.responseCallback;
    }

    public static final class Builder<T, U> {
        private String id;
        private T params;
        private String method;
        private Type responseType;

        public Builder<T, U> id(String val) {
            this.id = val;
            return this;
        }

        public Builder<T, U> params(T val) {
            this.params = val;
            return this;
        }

        public Builder<T, U> method(String val) {
            this.method = val;
            return this;
        }

        public Builder<T, U> responseType(Type val) {
            this.responseType = val;
            return this;
        }

        public RequestWrapperDTO<T, U> build() {
            return new RequestWrapperDTO(this);
        }
    }
}

