/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.scheduling;

import com.jn.langx.Builder;
import com.jn.langx.annotation.NotBlank;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Strings;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import com.jn.langx.util.timing.scheduling.Trigger;
import com.jn.langx.util.timing.scheduling.TriggerFactory;
import com.jn.langx.util.timing.scheduling.TriggerFactoryRegistry;

public class TriggerBuilder
implements Builder<Trigger> {
    private static Regexp EXPRESSION_REGEXP = Regexps.createRegexp("(?<type>\\w+)(?::(?<exp>.*))?");
    @NotBlank
    private String expression;
    @Nullable
    private TriggerFactoryRegistry registry;

    public TriggerBuilder expression(String expression) {
        if (expression != null) {
            this.expression = Strings.trimToNull(expression);
        }
        return this;
    }

    public TriggerBuilder registry(TriggerFactoryRegistry registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public Trigger build() {
        TriggerFactory factory;
        if (Strings.isBlank(this.expression)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal trigger expression: {}", this.expression));
        }
        RegexpMatcher matcher = EXPRESSION_REGEXP.matcher(this.expression);
        String triggerType = null;
        String exp = null;
        if (!matcher.matches()) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal trigger expression: {}", this.expression));
        }
        triggerType = matcher.group("type");
        exp = matcher.group("exp");
        if (Strings.isBlank(triggerType)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal trigger expression: {}, unrecognized trigger type: {}", this.expression, triggerType));
        }
        if (this.registry == null) {
            this.registry = TriggerFactoryRegistry.GLOBAL_TRIGGER_REGISTRY;
        }
        if ((factory = (TriggerFactory)this.registry.get(triggerType)) == null) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("illegal trigger expression: {}, unrecognized trigger type: {}", this.expression, triggerType));
        }
        return factory.get(exp);
    }
}

