/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.spi;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.comparator.OrderedComparator;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.spi.ServiceProvider;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class CommonServiceProvider<T>
implements ServiceProvider<T> {
    private Predicate<T> predicate = Functions.truePredicate();
    private Comparator<T> comparator = new OrderedComparator();

    public void setPredicate(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Iterator<T> get(Class<T> serviceClass) {
        ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
        Iterator<T> iter = loader.iterator();
        List<T> ret = Collects.emptyArrayList();
        while (iter.hasNext()) {
            T t = iter.next();
            if (!this.predicate.test(t)) continue;
            ret.add(t);
        }
        if (this.comparator != null) {
            ret = Collects.sort(ret, this.comparator);
        }
        return ret.iterator();
    }
}

