/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pattern.glob;

import com.jn.langx.exception.SyntaxException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class GlobPattern {
    private static final char BACKSLASH = '\\';
    private Regexp regexp;
    private boolean hasWildcard = false;

    public GlobPattern(String globPattern) {
        this.set(globPattern);
    }

    public Regexp getRegexp() {
        return this.regexp;
    }

    public static Regexp compile(String globPattern) {
        return new GlobPattern(globPattern).getRegexp();
    }

    public boolean matches(CharSequence s) {
        return this.regexp.matcher(s).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(String glob) {
        StringBuilder pattern = new StringBuilder();
        int setOpen = 0;
        int curlyOpen = 0;
        int len = glob.length();
        this.hasWildcard = false;
        block13: for (int i = 0; i < len; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= len) {
                        GlobPattern.error("Missing escaped character", glob, i);
                    }
                    pattern.append(c).append(glob.charAt(i));
                    continue block13;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '|': {
                    pattern.append('\\');
                    break;
                }
                case '*': {
                    pattern.append('.');
                    this.hasWildcard = true;
                    break;
                }
                case '?': {
                    pattern.append('.');
                    this.hasWildcard = true;
                    continue block13;
                }
                case '{': {
                    pattern.append("(?:");
                    ++curlyOpen;
                    this.hasWildcard = true;
                    continue block13;
                }
                case ',': {
                    pattern.append(curlyOpen > 0 ? (char)'|' : (char)c);
                    continue block13;
                }
                case '}': {
                    if (curlyOpen <= 0) break;
                    --curlyOpen;
                    pattern.append(")");
                    continue block13;
                }
                case '[': {
                    if (setOpen > 0) {
                        GlobPattern.error("Unclosed character class", glob, i);
                    }
                    ++setOpen;
                    this.hasWildcard = true;
                    break;
                }
                case '^': {
                    if (setOpen != 0) break;
                    pattern.append('\\');
                    break;
                }
                case '!': {
                    pattern.append((char)(setOpen > 0 && '[' == glob.charAt(i - 1) ? 94 : 33));
                    continue block13;
                }
                case ']': {
                    setOpen = 0;
                }
            }
            pattern.append(c);
        }
        if (setOpen > 0) {
            GlobPattern.error("Unclosed character class", glob, len);
        }
        if (curlyOpen > 0) {
            GlobPattern.error("Unclosed group", glob, len);
        }
        this.regexp = Regexps.createRegexp(pattern.toString());
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }

    private static void error(String message, String pattern, int pos) {
        String fullMessage = StringTemplates.formatWithPlaceholder("syntax error: {} at pos {} in: {}", message, pos, pattern);
        throw new SyntaxException(fullMessage);
    }
}

