/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Objs;
import com.jn.langx.util.logging.Loggers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;

public final class Signals {
    private Signals() {
    }

    public static Object register(String signalName, Runnable signalHandler) {
        Objs.requireNonNull(signalHandler);
        return Signals.register(signalName, signalHandler, signalHandler.getClass().getClassLoader());
    }

    public static Object register(final String signalName, final Runnable handler, ClassLoader loader) {
        final Logger logger = Loggers.getLogger(Signals.class);
        try {
            final Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(loader, new Class[]{signalHandlerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getDeclaringClass() == Object.class) {
                        if ("toString".equals(method.getName())) {
                            return handler.toString();
                        }
                    } else if (method.getDeclaringClass() == signalHandlerClass) {
                        logger.debug("Calling handler {} for signal {}", (Object)Signals.toStringx(handler), (Object)signalName);
                        handler.run();
                    }
                    return null;
                }
            });
            return Signals.doRegister(signalName, signalHandler);
        }
        catch (Exception e) {
            logger.debug("Error registering handler for signal ", (Object)signalName, (Object)e);
            return null;
        }
    }

    public static Object registerDefault(String name) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            return Signals.doRegister(name, signalHandlerClass.getField("SIG_DFL").get(null));
        }
        catch (Exception e) {
            Logger logger = Loggers.getLogger(Signals.class);
            logger.debug("Error registering default handler for signal ", (Object)name, (Object)e);
            return null;
        }
    }

    public static void unregister(String name, Object previous) {
        try {
            if (previous != null) {
                Signals.doRegister(name, previous);
            }
        }
        catch (Exception e) {
            Logger logger = Loggers.getLogger(Signals.class);
            logger.debug("Error unregistering handler for signal ", (Object)name, (Object)e);
        }
    }

    private static Object doRegister(String name, Object handler) throws Exception {
        Object signal;
        Logger logger = Loggers.getLogger(Signals.class);
        logger.debug("Registering signal {} with handler ", (Object)Signals.toStringx(handler));
        Class<?> signalClass = Class.forName("sun.misc.Signal");
        Constructor<?> constructor = signalClass.getConstructor(String.class);
        try {
            signal = constructor.newInstance(name);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                logger.debug("Ignoring unsupported signal {}", (Object)name);
            } else {
                logger.debug("Error registering handler for signal ", (Object)name, (Object)e);
            }
            return null;
        }
        Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
        return signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signal, handler);
    }

    private static String toStringx(Object handler) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            if (handler == signalHandlerClass.getField("SIG_DFL").get(null)) {
                return "SIG_DFL";
            }
            if (handler == signalHandlerClass.getField("SIG_IGN").get(null)) {
                return "SIG_IGN";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler != null ? handler.toString() : "null";
    }
}

