/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash;

import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.registry.Registry;
import com.jn.langx.security.SecurityException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.hash.Hasher;
import com.jn.langx.util.hash.UnsupportedHashAlgorithmException;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;
import com.jn.langx.util.hash.streaming.HMacHasher;
import com.jn.langx.util.hash.streaming.MessageDigestHasher;
import com.jn.langx.util.hash.streaming.crc.CRCs;
import com.jn.langx.util.hash.streaming.crc.CrcHasher;
import com.jn.langx.util.logging.Loggers;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public class Hashs {
    private static final Logger logger = Loggers.getLogger(Hashs.class);
    private static final Registry<String, Hasher> hasherFactoryRegistry;

    public static long hash(Hasher hasher, byte[] bytes) {
        return Hashs.hash(hasher, bytes, bytes.length, 0L);
    }

    public static long hash(Hasher hasher, byte[] bytes, long seed) {
        return Hashs.hash(hasher, bytes, bytes.length, seed);
    }

    public static long hash(Hasher hasher, byte[] bytes, int length, long seed) {
        return hasher.hash(bytes, length, seed);
    }

    public static long hash(String hasher, Object initParams, byte[] bytes, int length, long seed) {
        return Hashs.getHasher(hasher, initParams).hash(bytes, length, seed);
    }

    public static <H extends Hasher> H getHasher(String hasherName, Object initParams) {
        Hasher factory;
        if ("murmur".equals(hasherName)) {
            hasherName = "murmur2";
        }
        if ((factory = (Hasher)hasherFactoryRegistry.get(Strings.lowerCase(hasherName))) != null) {
            return (H)factory.get(initParams);
        }
        if (hasherName.startsWith("hmac-")) {
            String hmac = Strings.substring(hasherName, "hmac-".length());
            Object[] params = new Object[]{hmac, initParams};
            return (H)new HMacHasher().get(params);
        }
        if (hasherName.startsWith("messagedigest-")) {
            String digestAlgorithm = Strings.substring(hasherName, "messagedigest-".length());
            return (H)new MessageDigestHasher(digestAlgorithm);
        }
        AbstractStreamingHasher hasher = null;
        try {
            hasher = new HMacHasher(hasherName, (byte[])initParams);
            return (H)hasher;
        }
        catch (SecurityException ex) {
            Throwable cause = ex.getCause();
            if (!(cause instanceof NoSuchAlgorithmException)) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            try {
                hasher = new MessageDigestHasher(hasherName);
                return (H)hasher;
            }
            catch (SecurityException ex2) {
                cause = ex2.getCause();
                if (!(cause instanceof NoSuchAlgorithmException)) {
                    logger.error(ex2.getMessage(), (Throwable)ex2);
                }
                throw new UnsupportedHashAlgorithmException(hasherName);
            }
        }
    }

    public static int hashToIndex(int hash, int length) {
        Preconditions.positive(length, "length");
        if (hash == Integer.MIN_VALUE) {
            return 0;
        }
        return Math.abs(hash) % length;
    }

    static {
        final GenericRegistry registry = new GenericRegistry(Collects.emptyHashMap(true));
        registry.init();
        Collects.forEach(ServiceLoader.load(Hasher.class), new Consumer<Hasher>(){

            @Override
            public void accept(Hasher factory) {
                registry.register(factory);
            }
        });
        hasherFactoryRegistry = registry;
        List<String> crcNames = CRCs.getCrcNames();
        Collects.forEach(crcNames, new Consumer<String>(){

            @Override
            public void accept(String name) {
                hasherFactoryRegistry.register(Strings.lowerCase(name), new CrcHasher(name));
            }
        });
    }
}

