/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.formatter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.datetime.formatter.AbstractUtcTimestampFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatter
extends AbstractUtcTimestampFormatter<Date> {
    private static final List<Class> SUPPORTED = Collects.immutableArrayList(Date.class);

    public DateFormatter() {
    }

    public DateFormatter(String pattern, TimeZone timeZone, Locale locale) {
        this.setPattern(pattern);
        this.setLocal(locale);
        this.setTimeZone(timeZone);
    }

    @Override
    public String format(Date date) {
        Preconditions.checkNotNullArgument(date, "date");
        SimpleDateFormat simpleDateFormat = GlobalThreadLocalMap.getSimpleDateFormat(this.getPattern(), this.getTimeZone(), this.getLocale());
        return simpleDateFormat.format(date);
    }

    @Override
    public List<Class> supported() {
        return SUPPORTED;
    }

    @Override
    public DateFormatter get() {
        return new DateFormatter();
    }
}

