/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent.lock;

import com.jn.langx.distributed.locks.AbstractDLock;
import com.jn.langx.util.logging.Loggers;
import java.util.concurrent.TimeUnit;

public abstract class DistributedLock
extends AbstractDLock {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long tryTime, TimeUnit tryUnit, long ttl, TimeUnit ttlUnit, boolean interruptibly) throws InterruptedException {
        Object v = this.getValue();
        tryUnit = tryUnit == null ? TimeUnit.MILLISECONDS : tryUnit;
        ttlUnit = ttlUnit == null ? TimeUnit.MILLISECONDS : ttlUnit;
        boolean locked = false;
        long start = System.currentTimeMillis();
        long waitTime = tryTime > 0L ? tryUnit.toMillis(tryTime) : 5L;
        long endTime = start + waitTime;
        while (!locked && waitTime > 0L) {
            block8: {
                locked = this.doLock(v, ttl, ttlUnit);
                waitTime = endTime - System.currentTimeMillis();
                if (!locked && waitTime > 0L) {
                    try {
                        DistributedLock distributedLock = this;
                        synchronized (distributedLock) {
                            this.wait(50L);
                        }
                    }
                    catch (InterruptedException ex) {
                        if (!interruptibly) break block8;
                        throw ex;
                    }
                }
            }
            long now = System.currentTimeMillis();
            waitTime = endTime - now;
            if (now - start <= 60000L) continue;
            Loggers.getLogger(this.getClass()).warn("LOCK SLOW :: key: {}, startTime: {}, pendingTime:{}", new Object[]{this.getKey(), start, now - start});
        }
        if (locked) {
            this.setValue(v);
        }
        return locked;
    }

    protected abstract String getKey();

    protected abstract Object getValue();

    protected abstract void setValue(Object var1);

    protected abstract boolean doLock(Object var1, long var2, TimeUnit var4);
}

