/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.multivalue;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.multivalue.CommonMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LinkedMultiValueMap<K, V>
extends CommonMultiValueMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3801124242820219131L;
    public static final LinkedMultiValueMap EMPTY = new LinkedMultiValueMap();

    public LinkedMultiValueMap() {
        this(16);
    }

    public LinkedMultiValueMap(int initialCapacity) {
        super(new LinkedHashMap(initialCapacity), new Supplier<K, Collection<V>>(){

            @Override
            public Collection<V> get(K input) {
                return Collects.emptyArrayList();
            }
        });
    }

    public LinkedMultiValueMap(Map<K, List<V>> otherMap) {
        this(otherMap == null ? 16 : otherMap.size());
        this.putAll((Map<K, Collection<V>>)otherMap);
    }

    public LinkedMultiValueMap(MultiValueMap<K, V> otherMap) {
        this(otherMap == null ? 16 : otherMap.size());
        this.putAll(otherMap);
    }

    @Override
    public boolean containsValue(final Object value) {
        return Collects.anyMatch(this.targetMap, new Predicate2<K, Collection<V>>(){

            @Override
            public boolean test(K key, Collection<V> values) {
                return values.contains(value);
            }
        });
    }

    public LinkedMultiValueMap<K, V> deepCopy() {
        final LinkedMultiValueMap<K, V> copy = new LinkedMultiValueMap<K, V>(this.targetMap.size());
        Collects.forEach(this.targetMap, new Consumer2<K, Collection<V>>(){

            @Override
            public void accept(K key, Collection<V> values) {
                copy.put(key, Collects.newArrayList(values));
            }
        });
        return copy;
    }

    public LinkedMultiValueMap<K, V> clone() {
        return this.deepCopy();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this.targetMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

