/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.graph.Edge;
import com.jn.langx.util.collection.graph.Graph;
import com.jn.langx.util.collection.graph.GraphTraverser;
import com.jn.langx.util.collection.graph.Vertex;
import com.jn.langx.util.collection.graph.VertexConsumer;
import com.jn.langx.util.collection.graph.VisitStatus;
import com.jn.langx.util.collection.graph.traverser.BreadthFirstGraphTraverser;
import com.jn.langx.util.collection.graph.traverser.DeepFirstGraphTraverser;
import com.jn.langx.util.collection.graph.traverser.TreeGraphTraverser;
import com.jn.langx.util.comparator.IntegerComparator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Graphs {
    private static final Supplier<String, VisitStatus> NOT_VISITED_SUPPLIER = new Supplier<String, VisitStatus>(){

        @Override
        public VisitStatus get(String name) {
            return VisitStatus.NOT_VISITED;
        }
    };
    public static final DeepFirstGraphTraverser DFS = new DeepFirstGraphTraverser();
    public static final TreeGraphTraverser TDFS = new TreeGraphTraverser();
    public static final BreadthFirstGraphTraverser BFS = new BreadthFirstGraphTraverser();

    public static Map<String, VisitStatus> newVisitStatusMap() {
        return Collects.emptyNonAbsentHashMap(NOT_VISITED_SUPPLIER);
    }

    public static VisitStatus getVisitStatus(Map<String, VisitStatus> statusMap, String name) {
        return Collects.wrapAsNonAbsentMap(statusMap, NOT_VISITED_SUPPLIER).get(name);
    }

    public static boolean isNotVisited(Map<String, VisitStatus> statusMap, String name) {
        return Graphs.getVisitStatus(statusMap, name) == VisitStatus.NOT_VISITED;
    }

    public static boolean isVisiting(Map<String, VisitStatus> statusMap, String name) {
        return Graphs.getVisitStatus(statusMap, name) == VisitStatus.VISITING;
    }

    public static void beginVisit(Map<String, VisitStatus> statusMap, String name) {
        statusMap.put(name, VisitStatus.VISITING);
    }

    public static void finishVisit(Map<String, VisitStatus> statusMap, String name) {
        statusMap.put(name, VisitStatus.VISITED);
    }

    public static List<String> hasCycle(Graph graph) {
        List vertices = graph.getVertices();
        Map<String, VisitStatus> vertexStateMap = Graphs.newVisitStatusMap();
        List<String> retValue = null;
        for (Vertex vertex : vertices) {
            if (Graphs.isNotVisited(vertexStateMap, vertex.getName()) && (retValue = Graphs.detectCycle(vertex, vertexStateMap)) != null) break;
        }
        return retValue;
    }

    public static List<String> detectCycle(Vertex vertex, Map<String, VisitStatus> vertexStateMap) {
        LinkedList<String> cycleStack = new LinkedList<String>();
        boolean hasCycle = Graphs.dfsVisitCheckCycle(vertex, cycleStack, vertexStateMap);
        if (hasCycle) {
            String label = cycleStack.getFirst();
            int pos = cycleStack.lastIndexOf(label);
            List<String> cycle = cycleStack.subList(0, pos + 1);
            Collections.reverse(cycle);
            return cycle;
        }
        return null;
    }

    public static List<String> detectCycle(Vertex vertex) {
        Map<String, VisitStatus> vertexStateMap = Graphs.newVisitStatusMap();
        return Graphs.detectCycle(vertex, vertexStateMap);
    }

    private static boolean dfsVisitCheckCycle(Vertex vertex, LinkedList<String> cycle, Map<String, VisitStatus> vertexStateMap) {
        cycle.addFirst(vertex.getName());
        Graphs.beginVisit(vertexStateMap, vertex.getName());
        List outgoing = vertex.getOutgoingVertices();
        for (Vertex v : outgoing) {
            if (Graphs.isNotVisited(vertexStateMap, v.getName())) {
                boolean hasCycle = Graphs.dfsVisitCheckCycle(v, cycle, vertexStateMap);
                if (!hasCycle) continue;
                return true;
            }
            if (!Graphs.isVisiting(vertexStateMap, v.getName())) continue;
            cycle.addFirst(v.getName());
            return true;
        }
        Graphs.finishVisit(vertexStateMap, vertex.getName());
        cycle.removeFirst();
        return false;
    }

    public static <T> void traverse(final GraphTraverser traverser, final Graph<T> graph, final VertexConsumer<T> consumer) {
        final LinkedHashMap visitStatusMap = new LinkedHashMap();
        Collects.forEach(graph.getVertices(), new Consumer<Vertex<T>>(){

            @Override
            public void accept(Vertex<T> vertex) {
                traverser.traverse(visitStatusMap, graph, vertex.getName(), consumer);
            }
        });
    }

    public static <T> void traverse(@NonNull GraphTraverser traverser, Graph<T> graph, String vertexName, VertexConsumer<T> consumer) {
        traverser.traverse(graph, vertexName, consumer);
    }

    public static <T> List<Vertex<T>> sort(@NonNull GraphTraverser traverser, Graph<T> graph) {
        final ArrayList<Vertex<T>> retValue = new ArrayList<Vertex<T>>();
        VertexConsumer consumer = new VertexConsumer<T>(){

            @Override
            public void accept(Graph<T> graph, Vertex<T> vertex, Edge<T> edge) {
                retValue.add(vertex);
            }
        };
        Graphs.traverse(traverser, graph, consumer);
        return retValue;
    }

    public static <T> List<Vertex<T>> sort(@NonNull GraphTraverser traverser, Graph<T> graph, String vertexName) {
        final ArrayList<Vertex<T>> retValue = new ArrayList<Vertex<T>>();
        VertexConsumer consumer = new VertexConsumer<T>(){

            @Override
            public void accept(Graph<T> graph, Vertex<T> vertex, Edge<T> edge) {
                retValue.add(vertex);
            }
        };
        Graphs.traverse(traverser, graph, vertexName, consumer);
        return retValue;
    }

    public static <T> List<Vertex<T>> dfsSort(Graph<T> graph) {
        return Graphs.sort(DFS, graph);
    }

    public static <T> List<Vertex<T>> dfsSort(Graph<T> graph, String vertexName) {
        return Graphs.sort(DFS, graph, vertexName);
    }

    public static <T> List<Vertex<T>> tdfsSort(Graph<T> graph) {
        final ArrayList retValue = new ArrayList();
        VertexConsumer consumer = new VertexConsumer<T>(){

            @Override
            public void accept(Graph<T> graph, Vertex<T> vertex, Edge<T> edge) {
                int minToIndex = -1;
                List<Integer> indexes = Pipeline.of(vertex.getOutgoingVertices()).map(new Function<Vertex<T>, Integer>(){

                    @Override
                    public Integer apply(Vertex<T> to) {
                        return retValue.lastIndexOf(to);
                    }
                }).filter(new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer index) {
                        return index >= 0;
                    }
                }).asList();
                if (Objs.isNotEmpty(indexes)) {
                    minToIndex = indexes.size() == 1 ? indexes.get(0).intValue() : Pipeline.of(indexes).min(new IntegerComparator()).intValue();
                }
                if (minToIndex < 0) {
                    retValue.add(vertex);
                } else {
                    retValue.add(minToIndex, vertex);
                }
            }
        };
        Graphs.traverse(TDFS, graph, consumer);
        return Collects.asList(retValue);
    }

    public static <T> List<Vertex<T>> tdfsSort(Graph<T> graph, String vertexName) {
        final ArrayList retValue = new ArrayList();
        VertexConsumer consumer = new VertexConsumer<T>(){

            @Override
            public void accept(Graph<T> graph, Vertex<T> vertex, Edge<T> edge) {
                int minToIndex = -1;
                List<Integer> indexes = Pipeline.of(vertex.getOutgoingVertices()).map(new Function<Vertex<T>, Integer>(){

                    @Override
                    public Integer apply(Vertex<T> to) {
                        return retValue.lastIndexOf(to);
                    }
                }).filter(new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer index) {
                        return index >= 0;
                    }
                }).asList();
                if (Objs.isNotEmpty(indexes)) {
                    minToIndex = indexes.size() == 1 ? indexes.get(0).intValue() : Pipeline.of(indexes).min(new IntegerComparator()).intValue();
                }
                if (minToIndex < 0) {
                    retValue.add(vertex);
                } else {
                    retValue.add(minToIndex, vertex);
                }
            }
        };
        Graphs.traverse(TDFS, graph, vertexName, consumer);
        return Collects.asList(retValue);
    }

    public static <T> List<Vertex<T>> bfsSort(Graph<T> graph, String vertexName) {
        return Graphs.sort(BFS, graph, vertexName);
    }

    public static <T> List<Vertex<T>> bfsSort(Graph<T> graph) {
        return Graphs.sort(BFS, graph);
    }
}

