/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.ParseException;
import com.jn.langx.util.Calendars;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.datetime.DateField;
import com.jn.langx.util.datetime.DateTimeFormatter;
import com.jn.langx.util.datetime.DateTimeFormatterFactory;
import com.jn.langx.util.datetime.DateTimeFormatterFactoryRegistry;
import com.jn.langx.util.datetime.DateTimeParsedResult;
import com.jn.langx.util.datetime.NotFoundDateTimeFormatterException;
import com.jn.langx.util.datetime.TimeZoneAware;
import com.jn.langx.util.datetime.parser.CandidatePatternsDateTimeParser;
import com.jn.langx.util.reflect.Reflects;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class Dates {
    public static final int MINUTES_TO_SECONDS = 60;
    public static final int HOURS_TO_SECONDS = 3600;
    public static final int DAY_TO_SECONDS = 86400;
    public static final long SECONDS_TO_MILLIS = 1000L;
    public static final long MINUTES_TO_MILLIS = 60000L;
    public static final long HOURS_TO_MILLIS = 3600000L;
    public static final long DAY_TO_MILLIS = 86400000L;
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String yyyy_MM_dd_1 = "yyyy-M-d";
    public static final String yyyy_MM_dd_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String yyyy_MM_dd_CN_1 = "yyyy\u5e74M\u6708d\u65e5";
    public static final String dd_MM_yyyy = "dd/MM/yyyy";
    public static final String MM_dd_yyyy = "MM/dd/yyyy";
    public static final String MM_dd_yyyy_1 = "M/d/yyyy";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyy_MM_dd_HH_mm_ss_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String yyyy_MM_dd_T_HH_mm_ss = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String yyyy_MM_dd_T_HH_mm_ssZone = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String HH_mm_ss = "HH:mm:ss";
    public static final String HH_mm_ss_CN = "HH\u65f6mm\u5206ss\u79d2";
    public static final String HH_MM_ssZone = "HH:mm:ssZZ";
    public static final char[] DATE_FORMAT_FLAGS = new char[]{'G', 'y', 'Y', 'M', 'w', 'W', 'D', 'd', 'F', 'E', 'u', 'a', 'H', 'k', 'K', 'h', 'm', 's', 'S', 'z', 'Z', 'X'};

    @Deprecated
    public static String format(long millis, @NonNull String pattern) {
        Preconditions.checkTrue(millis >= 0L);
        return Dates.format(millis, pattern, null, null);
    }

    @Deprecated
    public static String format(@NonNull Date date) {
        return Dates.format(date);
    }

    @Deprecated
    public static String format(@NonNull Date date, @NotEmpty String pattern) {
        return Dates.format(date, pattern, null, null);
    }

    public static <DATE_TIME> String format(DATE_TIME dateTime) {
        return Dates.format(dateTime, yyyy_MM_dd_HH_mm_ss);
    }

    public static <DATE_TIME> String format(DATE_TIME dateTime, String pattern) {
        return Dates.format(dateTime, pattern, null, null);
    }

    public static <DATE_TIME> String format(DATE_TIME dateTime, String pattern, TimeZone timeZone) {
        return Dates.format(dateTime, pattern, timeZone, null);
    }

    public static <DATE_TIME> String format(DATE_TIME dateTime, String pattern, Locale locale) {
        return Dates.format(dateTime, pattern, null, locale);
    }

    public static <DATE_TIME> String format(@NonNull DATE_TIME dateTime, @NotEmpty String pattern, @Nullable TimeZone timeZone, @Nullable Locale locale) {
        Preconditions.checkNotEmpty(pattern, "pattern is empty");
        Preconditions.checkNotNull(dateTime);
        DateTimeFormatterFactory factory = DateTimeFormatterFactoryRegistry.getInstance().get(dateTime.getClass());
        if (factory == null) {
            throw new NotFoundDateTimeFormatterException(Reflects.getFQNClassName(dateTime.getClass()));
        }
        DateTimeFormatter<DATE_TIME> formatter = factory.get();
        if (timeZone != null && formatter instanceof TimeZoneAware) {
            ((TimeZoneAware)((Object)formatter)).setTimeZone(timeZone);
        }
        formatter.setPattern(pattern);
        formatter.setLocal(locale);
        return formatter.format(dateTime);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, locale);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable TimeZone timeZone) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZone);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable String timeZoneId) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZoneId);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable TimeZone timeZone, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZone, locale);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable String timeZoneId, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZoneId, locale);
    }

    public static Date parse(String dateString, @NotEmpty String pattern) {
        return Dates.parse(dateString, new String[]{pattern});
    }

    public static Date parse(String dateString, String ... patterns) {
        return Dates.parse(dateString, Collects.asList(patterns));
    }

    public static Date parse(String dateString, List<String> patterns) {
        return Dates.parse(dateString, null, null, patterns);
    }

    public static Date parse(String dateString, TimeZone tz, Locale locale, List<String> patterns) {
        if (Objs.length(patterns) == 1) {
            try {
                return Dates.getSimpleDateFormat(patterns.get(0), tz, locale).parse(dateString);
            }
            catch (java.text.ParseException e) {
                throw new ParseException(e);
            }
        }
        DateTimeParsedResult dateTimeParsedResult = new CandidatePatternsDateTimeParser(patterns).addLocale(locale).addTimeZone(tz).parse(dateString);
        if (dateTimeParsedResult != null) {
            return new Date(dateTimeParsedResult.getTimestamp());
        }
        return null;
    }

    public static Date addYears(Date date, int amount) {
        return Dates.add(date, DateField.YEAR, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return Dates.add(date, DateField.MONTH, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return Dates.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return Dates.add(date, DateField.DAY, amount);
    }

    public static Date addHours(Date date, int amount) {
        return Dates.add(date, DateField.HOUR, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return Dates.add(date, DateField.MINUTE, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return Dates.add(date, DateField.SECOND, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return Dates.add(date, DateField.MILLIS, amount);
    }

    public static Date add(Date date, int calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date add(Date date, DateField calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendars.addField(c, calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return Dates.set(date, DateField.YEAR, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return Dates.setMonths(date, amount, false);
    }

    public static Date setMonths(Date date, int amount, boolean valueIsActual) {
        return Dates.set(date, DateField.MONTH, valueIsActual ? amount - 1 : amount);
    }

    public static Date setDays(Date date, int amount) {
        return Dates.set(date, DateField.DAY, amount);
    }

    public static Date setHours(Date date, int amount) {
        return Dates.set(date, DateField.HOUR, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return Dates.set(date, DateField.MINUTE, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return Dates.set(date, DateField.SECOND, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return Dates.set(date, DateField.MILLIS, amount);
    }

    public static Date set(Date date, DateField field, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        Calendars.setField(c, field, amount);
        return c.getTime();
    }

    public static int get(@NonNull Date date, DateField field) {
        return Calendars.getField(Dates.toCalendar(date), field);
    }

    public static int getYears(@NonNull Date date) {
        return Calendars.getYears(Dates.toCalendar(date));
    }

    public static int getMonths(@NonNull Date date) {
        return Dates.getMonths(date, false);
    }

    public static int getMonths(@NonNull Date date, boolean getActualMonth) {
        return Calendars.getMonths(Dates.toCalendar(date), getActualMonth);
    }

    public static int getDays(@NonNull Date date) {
        return Calendars.getDays(Dates.toCalendar(date));
    }

    public static int getHours(@NonNull Date date) {
        return Calendars.getHours(Dates.toCalendar(date));
    }

    public static int getMinutes(@NonNull Date date) {
        return Calendars.getMinutes(Dates.toCalendar(date));
    }

    public static int getSeconds(@NonNull Date date) {
        return Calendars.getSeconds(Dates.toCalendar(date));
    }

    public static int getMillis(@NonNull Date date) {
        return Calendars.getMillis(Dates.toCalendar(date));
    }

    public static long nextTime(long baselineInMills, long durationInMills) {
        Preconditions.checkTrue(baselineInMills >= 0L);
        Preconditions.checkTrue(durationInMills >= 0L);
        if (Long.MAX_VALUE - baselineInMills <= durationInMills) {
            return Long.MAX_VALUE;
        }
        return baselineInMills + durationInMills;
    }

    public static long nextTime(long durationInMills) {
        if (durationInMills < 0L) {
            return Long.MAX_VALUE;
        }
        return Dates.nextTime(System.currentTimeMillis(), durationInMills);
    }

    public static long nowMills() {
        return System.currentTimeMillis();
    }

    public static Date now() {
        return new Date();
    }

    public static String nowReadableString() {
        return Dates.format(new Date(), yyyy_MM_dd_HH_mm_ss);
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(date);
        return c;
    }

    public static TimeZone localTimeZone() {
        return TimeZone.getDefault();
    }
}

