/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl.keymanager;

import com.jn.langx.security.ssl.PrivateKeyDetails;
import com.jn.langx.security.ssl.keymanager.PrivateKeyAliasChooseStrategy;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public final class InternalKeyManagerProxy
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager delegate;
    private final PrivateKeyAliasChooseStrategy aliasStrategy;

    public InternalKeyManagerProxy(X509ExtendedKeyManager delegate, PrivateKeyAliasChooseStrategy aliasStrategy) {
        this.delegate = delegate;
        this.aliasStrategy = aliasStrategy;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate.getClientAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    private Map<String, PrivateKeyDetails> getClientAliasMap(String[] keyTypes, Principal[] issuers) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        for (String keyType : keyTypes) {
            String[] aliases = this.delegate.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.delegate.getCertificateChain(alias)));
            }
        }
        return validAliases;
    }

    private Map<String, PrivateKeyDetails> getServerAliasMap(String keyType, Principal[] issuers) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        String[] aliases = this.delegate.getServerAliases(keyType, issuers);
        if (aliases != null) {
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.delegate.getCertificateChain(alias)));
            }
        }
        return validAliases;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, null);
    }
}

