/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.ClassPathResource;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.ResourceLoader;
import com.jn.langx.io.resource.UrlResource;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.net.URLs;
import java.net.URL;

public class DefaultResourceLoader
implements ResourceLoader {
    protected ClassLoader classLoader;

    public DefaultResourceLoader() {
        this.classLoader = ClassLoaders.getDefaultClassLoader();
    }

    public DefaultResourceLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = Emptys.isNull(classLoader) ? ClassLoaders.getDefaultClassLoader() : classLoader;
    }

    @Override
    public <V extends Resource> V loadResource(String location) {
        Preconditions.checkNotNull(location);
        if (location.startsWith("classpath:")) {
            return (V)new ClassPathResource(location, this.classLoader);
        }
        if (location.startsWith("file:") && !location.startsWith("file://")) {
            return (V)new FileResource(location);
        }
        URL url = URLs.newURL(location);
        if (url != null) {
            return (V)new UrlResource(url);
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

