/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.distributed.session.impl;

import com.jn.langx.distributed.session.Session;
import com.jn.langx.distributed.session.SessionContext;
import com.jn.langx.distributed.session.SessionEvent;
import com.jn.langx.distributed.session.SessionException;
import com.jn.langx.distributed.session.SessionFactory;
import com.jn.langx.distributed.session.SessionListener;
import com.jn.langx.distributed.session.SessionManager;
import com.jn.langx.distributed.session.SessionManagerAware;
import com.jn.langx.distributed.session.SessionRepository;
import com.jn.langx.distributed.session.impl.LocalSessionRepository;
import com.jn.langx.distributed.session.impl.SimpleSessionFactory;
import com.jn.langx.event.EventPublisher;
import com.jn.langx.event.EventPublisherAware;
import com.jn.langx.event.local.SimpleEventPublisher;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DefaultSessionManager
extends AbstractInitializable
implements SessionManager,
EventPublisherAware {
    private SessionFactory sessionFactory;
    protected SessionRepository repository;
    private long defaultTimeout = TimeUnit.MINUTES.toMillis(30L);
    private EventPublisher<SessionEvent> eventPublisher;
    private String domain = "SESSION";

    @Override
    public Session getSession(SessionContext context) {
        String id = context.getSessionId();
        if (Strings.isNotBlank(id)) {
            return this.getSession(id);
        }
        return this.createSession(context);
    }

    private Session createSession(SessionContext context) {
        Session session = this.sessionFactory.get(context);
        long maxInactiveInterval = session.getMaxInactiveInterval();
        if (maxInactiveInterval <= 0L) {
            session.setMaxInactiveInterval(this.getDefaultTimeout());
        }
        Date startTime = session.getStartTime();
        Preconditions.checkNotNull(startTime, "the start time is null");
        Date lastAccessTime = session.getLastAccessTime();
        if (lastAccessTime == null) {
            session.setLastAccessTime(new Date());
        }
        String sessionId = session.getId();
        Preconditions.checkNotEmpty(sessionId, "the session id is empty or null");
        this.repository.add(session);
        if (session instanceof SessionManagerAware) {
            ((SessionManagerAware)((Object)session)).setSessionManager(this);
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publish(new SessionEvent(this.domain, SessionEvent.SessionEventType.CREATED, session));
        }
        return session;
    }

    @Override
    public Session getSession(String sessionId) throws SessionException {
        if (Strings.isBlank(sessionId)) {
            return null;
        }
        Session session = this.repository.getById(sessionId);
        if (session != null) {
            if (!session.isExpired()) {
                session.setLastAccessTime(new Date());
                if (session instanceof SessionManagerAware) {
                    ((SessionManagerAware)((Object)session)).setSessionManager(this);
                }
                this.repository.update(session);
                return session;
            }
            this.repository.removeById(session.getId());
            if (this.eventPublisher != null) {
                this.eventPublisher.publish(new SessionEvent(this.domain, SessionEvent.SessionEventType.EXPIRE, session));
            }
        }
        return null;
    }

    @Override
    public void invalidate(Session session) {
        if (session != null) {
            this.repository.removeById(session.getId());
            if (this.eventPublisher != null) {
                this.eventPublisher.publish(new SessionEvent(this.domain, SessionEvent.SessionEventType.INVALIDATED, session));
            }
        }
    }

    public SessionRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SessionRepository repository) {
        this.repository = repository;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.eventPublisher.addEventListener(this.domain, sessionListener);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        Preconditions.checkNotEmpty(domain);
        this.domain = domain;
    }

    @Override
    protected void doInit() throws InitializationException {
        if (this.eventPublisher == null) {
            this.setEventPublisher(new SimpleEventPublisher());
        }
        if (this.sessionFactory == null) {
            this.setSessionFactory(new SimpleSessionFactory());
        }
        if (this.repository == null) {
            this.setRepository(new LocalSessionRepository());
        }
    }
}

