/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.cache;

import com.jn.langx.cache.AbstractCache;
import com.jn.langx.cache.Entry;
import com.jn.langx.cache.RemoveCause;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.timing.timer.Timer;
import java.util.LinkedHashMap;
import java.util.List;

public class FIFOCache<K, V>
extends AbstractCache<K, V> {
    private LinkedHashMap<K, K> queue = new LinkedHashMap();

    public FIFOCache() {
        super(Integer.MAX_VALUE, 60000L);
    }

    public FIFOCache(int maxCapacity, long evictExpiredInterval) {
        super(maxCapacity, evictExpiredInterval);
    }

    public FIFOCache(int maxCapacity, long evictExpiredInterval, Timer timer) {
        super(maxCapacity, evictExpiredInterval, timer);
    }

    @Override
    protected void addToCache(Entry<K, V> entry) {
        Object key = entry.getKey();
        if (key != null) {
            this.queue.put(key, key);
        }
    }

    @Override
    protected void beforeRecomputeExpireTimeOnRead(Entry<K, V> entry) {
    }

    @Override
    protected void afterRecomputeExpireTimeOnRead(Entry<K, V> entry) {
    }

    @Override
    protected void beforeRead(Entry<K, V> entry) {
    }

    @Override
    protected void afterRead(Entry<K, V> entry) {
    }

    @Override
    protected void removeFromCache(Entry<K, V> entry, RemoveCause removeCause) {
        Object key = entry.getKey();
        if (key != null) {
            this.queue.remove(entry.getKey());
        }
    }

    @Override
    protected List<K> forceEvict(int count) {
        return Pipeline.of(this.queue.keySet()).findN(count).asList();
    }
}

