/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.beans;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.ConcurrentReferenceHashMap;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.GenericTypeResolver;
import com.jn.langx.util.reflect.type.SimpleParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

final class BeanProperty {
    private static Map<BeanProperty, Annotation[]> annotationCache = new ConcurrentReferenceHashMap<BeanProperty, Annotation[]>();
    private final Class<?> objectType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final SimpleParameter methodParameter;
    private Annotation[] annotations;

    public BeanProperty(Class<?> objectType, Method readMethod, Method writeMethod) {
        this(objectType, readMethod, writeMethod, null);
    }

    public BeanProperty(Class<?> objectType, Method readMethod, Method writeMethod, String name) {
        this.objectType = objectType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.methodParameter = this.resolveMethodParameter();
        this.name = name != null ? name : this.resolveName();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.methodParameter.getParameterType();
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    SimpleParameter getMethodParameter() {
        return this.methodParameter;
    }

    Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    private String resolveName() {
        if (this.readMethod != null) {
            int index = this.readMethod.getName().indexOf("get");
            if (index != -1) {
                index += 3;
            } else {
                index = this.readMethod.getName().indexOf("is");
                if (index == -1) {
                    throw new IllegalArgumentException("Not a getter method");
                }
                index += 2;
            }
            return Strings.uncapitalize(this.readMethod.getName().substring(index));
        }
        int index = this.writeMethod.getName().indexOf("set");
        if (index == -1) {
            throw new IllegalArgumentException("Not a setter method");
        }
        return Strings.uncapitalize(this.writeMethod.getName().substring(index += 3));
    }

    private SimpleParameter resolveMethodParameter() {
        SimpleParameter read = this.resolveReadMethodParameter();
        SimpleParameter write = this.resolveWriteMethodParameter();
        if (write == null) {
            if (read == null) {
                throw new IllegalStateException("Property is neither readable nor writeable");
            }
            return read;
        }
        if (read != null) {
            Class<?> readType = read.getParameterType();
            Class<?> writeType = write.getParameterType();
            if (!writeType.equals(readType) && writeType.isAssignableFrom(readType)) {
                return read;
            }
        }
        return write;
    }

    private SimpleParameter resolveReadMethodParameter() {
        if (this.getReadMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new SimpleParameter(this.getReadMethod(), -1));
    }

    private SimpleParameter resolveWriteMethodParameter() {
        if (this.getWriteMethod() == null) {
            return null;
        }
        return this.resolveParameterType(new SimpleParameter(this.getWriteMethod(), 0));
    }

    private SimpleParameter resolveParameterType(SimpleParameter parameter) {
        GenericTypeResolver.resolveParameterType(parameter, this.getObjectType());
        return parameter;
    }

    private Annotation[] resolveAnnotations() {
        Annotation[] annotations = annotationCache.get(this);
        if (annotations == null) {
            LinkedHashMap<Class<? extends Annotation>, Annotation> annotationMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            this.addAnnotationsToMap(annotationMap, this.getReadMethod());
            this.addAnnotationsToMap(annotationMap, this.getWriteMethod());
            this.addAnnotationsToMap(annotationMap, this.getField());
            annotations = annotationMap.values().toArray(new Annotation[annotationMap.size()]);
            annotationCache.put(this, annotations);
        }
        return annotations;
    }

    private void addAnnotationsToMap(Map<Class<? extends Annotation>, Annotation> annotationMap, AnnotatedElement object) {
        if (object != null) {
            for (Annotation annotation : object.getAnnotations()) {
                annotationMap.put(annotation.annotationType(), annotation);
            }
        }
    }

    private Field getField() {
        String name = this.getName();
        if (Strings.isEmpty(name)) {
            return null;
        }
        Class<?> declaringClass = this.declaringClass();
        Field field = Reflects.findField(declaringClass, name);
        if (field == null && (field = Reflects.findField(declaringClass, Strings.uncapitalize(name))) == null) {
            field = Reflects.findField(declaringClass, Strings.capitalize(name));
        }
        return field;
    }

    private Class<?> declaringClass() {
        if (this.getReadMethod() != null) {
            return this.getReadMethod().getDeclaringClass();
        }
        return this.getWriteMethod().getDeclaringClass();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanProperty)) {
            return false;
        }
        BeanProperty otherProperty = (BeanProperty)other;
        return Objs.deepEquals(this.objectType, otherProperty.objectType) && Objs.deepEquals(this.name, otherProperty.name) && Objs.deepEquals(this.readMethod, otherProperty.readMethod) && Objs.deepEquals(this.writeMethod, otherProperty.writeMethod);
    }

    public int hashCode() {
        return Objs.hash(this.objectType, this.name);
    }
}

