/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotMutable;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.util.io.unicode.Utf8s;

@NotMutable
public final class ASN1UTF8String
extends ASN1Element {
    private static final long serialVersionUID = -2147537370903003997L;
    @NonNull
    private final String stringValue;

    public ASN1UTF8String(@Nullable String stringValue) {
        this(12, stringValue);
    }

    public ASN1UTF8String(byte type, @Nullable String stringValue) {
        this(type, stringValue, Utf8s.getBytes(stringValue));
    }

    private ASN1UTF8String(byte type, @Nullable String stringValue, @NonNull byte[] encodedValue) {
        super(type, encodedValue);
        this.stringValue = stringValue == null ? "" : stringValue;
    }

    @NonNull
    public String stringValue() {
        return this.stringValue;
    }

    @NonNull
    public static ASN1UTF8String decodeAsUTF8String(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            if (!Utf8s.isValidUTF8(elementValue)) {
                throw new ASN1Exception(ASN1Messages.ERR_UTF_8_STRING_DECODE_VALUE_NOT_UTF_8.get());
            }
            return new ASN1UTF8String(elementBytes[0], Utf8s.toString(elementValue), elementValue);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1UTF8String decodeAsUTF8String(@NonNull ASN1Element element) throws ASN1Exception {
        byte[] elementValue = element.getValue();
        if (!Utf8s.isValidUTF8(elementValue)) {
            throw new ASN1Exception(ASN1Messages.ERR_UTF_8_STRING_DECODE_VALUE_NOT_UTF_8.get());
        }
        return new ASN1UTF8String(element.getType(), Utf8s.toString(elementValue), elementValue);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.stringValue);
    }
}

