/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.util.io.unicode.Utf8s;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class ASN1UTCTime
extends ASN1Element {
    @NonNull
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS = new ThreadLocal();
    private static final long serialVersionUID = -3107099228691194285L;
    private final long time;
    @NonNull
    private final String stringRepresentation;

    public ASN1UTCTime() {
        this(23);
    }

    public ASN1UTCTime(byte type) {
        this(type, System.currentTimeMillis());
    }

    public ASN1UTCTime(@NonNull Date date) {
        this(23, date.getTime());
    }

    public ASN1UTCTime(byte type, @NonNull Date date) {
        this(type, date.getTime());
    }

    public ASN1UTCTime(long time) {
        this(23, time);
    }

    public ASN1UTCTime(byte type, long time) {
        super(type, Utf8s.getBytes(ASN1UTCTime.encodeTimestamp(time)));
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(time);
        calendar.set(14, 0);
        this.time = calendar.getTimeInMillis();
        this.stringRepresentation = ASN1UTCTime.encodeTimestamp(time);
    }

    public ASN1UTCTime(@NonNull String timestamp) throws ASN1Exception {
        this(23, timestamp);
    }

    public ASN1UTCTime(byte type, @NonNull String timestamp) throws ASN1Exception {
        super(type, Utf8s.getBytes(timestamp));
        this.time = ASN1UTCTime.decodeTimestamp(timestamp);
        this.stringRepresentation = timestamp;
    }

    @NonNull
    public static String encodeTimestamp(@NonNull Date date) {
        return ASN1UTCTime.getDateFormatter().format(date);
    }

    @NonNull
    private static SimpleDateFormat getDateFormatter() {
        SimpleDateFormat existingFormatter = DATE_FORMATTERS.get();
        if (existingFormatter != null) {
            return existingFormatter;
        }
        SimpleDateFormat newFormatter = new SimpleDateFormat("yyMMddHHmmss'Z'");
        newFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        newFormatter.setLenient(false);
        DATE_FORMATTERS.set(newFormatter);
        return newFormatter;
    }

    @NonNull
    public static String encodeTimestamp(long time) {
        return ASN1UTCTime.encodeTimestamp(new Date(time));
    }

    public static long decodeTimestamp(@NonNull String timestamp) throws ASN1Exception {
        if (timestamp.length() != 13) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_LENGTH.get());
        }
        if (!timestamp.endsWith("Z") && !timestamp.endsWith("z")) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_DOES_NOT_END_WITH_Z.get());
        }
        for (int i = 0; i < timestamp.length() - 1; ++i) {
            char c = timestamp.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_CHAR_NOT_DIGIT.get(i + 1));
        }
        int month = Integer.parseInt(timestamp.substring(2, 4));
        if (month < 1 || month > 12) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_MONTH.get());
        }
        int day = Integer.parseInt(timestamp.substring(4, 6));
        if (day < 1 || day > 31) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_DAY.get());
        }
        int hour = Integer.parseInt(timestamp.substring(6, 8));
        if (hour > 23) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_HOUR.get());
        }
        int minute = Integer.parseInt(timestamp.substring(8, 10));
        if (minute > 59) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_MINUTE.get());
        }
        int second = Integer.parseInt(timestamp.substring(10, 12));
        if (second > 60) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_SECOND.get());
        }
        try {
            return ASN1UTCTime.getDateFormatter().parse(timestamp).getTime();
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_CANNOT_PARSE.get(e.getMessage()), e);
        }
    }

    public long getTime() {
        return this.time;
    }

    @NonNull
    public Date getDate() {
        return new Date(this.time);
    }

    @NonNull
    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    @NonNull
    public static ASN1UTCTime decodeAsUTCTime(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            return new ASN1UTCTime(elementBytes[0], Utf8s.toString(elementValue));
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1UTCTime decodeAsUTCTime(@NonNull ASN1Element element) throws ASN1Exception {
        return new ASN1UTCTime(element.getType(), Utf8s.toString(element.getValue()));
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }
}

