/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.asn1.spec.ASN1StreamReader;

public final class ASN1StreamReaderSequence {
    @NonNull
    private final ASN1StreamReader reader;
    private final byte type;
    private final int length;
    private final long endBytesRead;

    ASN1StreamReaderSequence(@NonNull ASN1StreamReader reader, byte type, int length) {
        this.reader = reader;
        this.type = type;
        this.length = length;
        this.endBytesRead = reader.getTotalBytesRead() + (long)length;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasMoreElements() throws ASN1Exception {
        long currentBytesRead = this.reader.getTotalBytesRead();
        if (currentBytesRead == this.endBytesRead) {
            return false;
        }
        if (currentBytesRead < this.endBytesRead) {
            return true;
        }
        throw new ASN1Exception(ASN1Messages.ERR_STREAM_READER_SEQUENCE_READ_PAST_END.get(this.length, this.endBytesRead, currentBytesRead));
    }
}

