/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.bytestring.ByteString;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.unicode.Utf8s;

public final class ASN1OctetString
extends ASN1Element
implements ByteString {
    private static final long serialVersionUID = -7857753188341295516L;
    @Nullable
    private byte[] valueBytes;
    @Nullable
    private volatile byte[] valueBytesGuard;
    private int length;
    private int offset;
    @Nullable
    private String stringValue;

    public ASN1OctetString() {
        super((byte)4);
        this.valueBytes = Emptys.EMPTY_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(byte type) {
        super(type);
        this.valueBytes = Emptys.EMPTY_BYTES;
        this.stringValue = "";
        this.offset = 0;
        this.length = 0;
    }

    public ASN1OctetString(@Nullable byte[] value) {
        super((byte)4);
        if (value == null) {
            this.valueBytes = Emptys.EMPTY_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = value;
            this.stringValue = null;
            this.offset = 0;
            this.length = value.length;
        }
    }

    public ASN1OctetString(@NonNull byte[] value, int offset, int length) {
        super((byte)4);
        Preconditions.checkNotNull(value);
        Preconditions.checkTrue(offset >= 0 && length >= 0 && offset + length <= value.length);
        this.valueBytes = value;
        this.stringValue = null;
        this.offset = offset;
        this.length = length;
    }

    public ASN1OctetString(byte type, @Nullable byte[] value) {
        super(type);
        if (value == null) {
            this.valueBytes = Emptys.EMPTY_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = value;
            this.stringValue = null;
            this.offset = 0;
            this.length = value.length;
        }
    }

    public ASN1OctetString(byte type, @NonNull byte[] value, int offset, int length) {
        super(type);
        Preconditions.checkTrue(offset >= 0 && length >= 0 && offset + length <= value.length);
        this.valueBytes = value;
        this.stringValue = null;
        this.offset = offset;
        this.length = length;
    }

    public ASN1OctetString(@Nullable String value) {
        super((byte)4);
        if (value == null) {
            this.valueBytes = Emptys.EMPTY_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = value;
            this.offset = -1;
            this.length = -1;
        }
    }

    public ASN1OctetString(byte type, @Nullable String value) {
        super(type);
        if (value == null) {
            this.valueBytes = Emptys.EMPTY_BYTES;
            this.stringValue = "";
            this.offset = 0;
            this.length = 0;
        } else {
            this.valueBytes = null;
            this.stringValue = value;
            this.offset = -1;
            this.length = -1;
        }
    }

    @Override
    @NonNull
    byte[] getValueArray() {
        return this.getValue();
    }

    @Override
    int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return this.getValue().length;
    }

    @Override
    @NonNull
    public byte[] getValue() {
        if (this.valueBytes == null) {
            this.valueBytesGuard = Utf8s.getBytes(this.stringValue);
            this.offset = 0;
            this.length = this.valueBytesGuard.length;
            this.valueBytes = this.valueBytesGuard;
        } else if (this.offset != 0 || this.length != this.valueBytes.length) {
            byte[] newArray = new byte[this.length];
            System.arraycopy(this.valueBytes, this.offset, newArray, 0, this.length);
            this.offset = 0;
            this.valueBytesGuard = newArray;
            this.valueBytes = this.valueBytesGuard;
        }
        return this.valueBytes;
    }

    @Override
    public void encodeTo(@NonNull ByteStringBuffer buffer) {
        buffer.append(this.getType());
        if (this.valueBytes == null) {
            int stringLength = this.stringValue.length();
            int lengthStartPos = buffer.length();
            ASN1OctetString.encodeLengthTo(stringLength, buffer);
            int valueStartPos = buffer.length();
            buffer.append(this.stringValue);
            int stringBytesLength = buffer.length() - valueStartPos;
            if (stringBytesLength != stringLength) {
                byte[] newLengthBytes = ASN1OctetString.encodeLength(stringBytesLength);
                if (newLengthBytes.length == valueStartPos - lengthStartPos) {
                    System.arraycopy(newLengthBytes, 0, buffer.getBackingArray(), lengthStartPos, newLengthBytes.length);
                } else {
                    buffer.setLength(lengthStartPos);
                    buffer.append(newLengthBytes);
                    buffer.append(this.stringValue);
                }
            }
        } else {
            ASN1OctetString.encodeLengthTo(this.length, buffer);
            buffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    @Override
    @NonNull
    public String stringValue() {
        if (this.stringValue == null) {
            this.stringValue = this.length == 0 ? "" : Utf8s.toString(this.valueBytes, this.offset, this.length);
        }
        return this.stringValue;
    }

    @NonNull
    public static ASN1OctetString decodeAsOctetString(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            return new ASN1OctetString(elementBytes[0], elementBytes, valueStartPos, length);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1OctetString decodeAsOctetString(@NonNull ASN1Element element) {
        return new ASN1OctetString(element.getType(), element.getValue());
    }

    @Override
    public void appendValueTo(@NonNull ByteStringBuffer buffer) {
        if (this.valueBytes == null) {
            buffer.append(this.stringValue);
        } else {
            buffer.append(this.valueBytes, this.offset, this.length);
        }
    }

    @Override
    @NonNull
    public ASN1OctetString toASN1OctetString() {
        return this;
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.stringValue());
    }
}

