/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.deserializer.ContextualDeserializer;
import com.jn.langx.util.reflect.type.Primitives;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberDeserializer
extends JsonDeserializer<Number>
implements ContextualDeserializer {
    private Class<? extends Number> clazz;

    public NumberDeserializer() {
    }

    public NumberDeserializer(Class clazz) {
        this.clazz = clazz;
    }

    public Class<?> handledType() {
        return this.clazz;
    }

    public Number deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = p.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String v = p.getValueAsString();
            if (Primitives.isLong(this.clazz)) {
                return Long.parseLong(v);
            }
            if (Primitives.isDouble(this.clazz)) {
                return Double.parseDouble(v);
            }
            if (Primitives.isInteger(this.clazz)) {
                return Integer.parseInt(v);
            }
            if (Primitives.isFloat(this.clazz)) {
                return Float.valueOf(Float.parseFloat(v));
            }
            if (Primitives.isShort(this.clazz)) {
                return Short.parseShort(v);
            }
            if (Primitives.isByte(this.clazz)) {
                return Byte.parseByte(v);
            }
            if (this.clazz == BigDecimal.class) {
                return p.getDecimalValue();
            }
            if (this.clazz == BigInteger.class) {
                return p.getBigIntegerValue();
            }
        }
        if (!curr.isNumeric()) {
            return 0;
        }
        Number n = null;
        if (Primitives.isDouble(this.clazz)) {
            n = p.getDoubleValue();
        } else if (Primitives.isLong(this.clazz)) {
            n = p.getLongValue();
        } else if (Primitives.isFloat(this.clazz)) {
            n = Float.valueOf(p.getFloatValue());
        } else if (Primitives.isInteger(this.clazz)) {
            n = p.getIntValue();
        } else if (Primitives.isShort(this.clazz)) {
            n = p.getShortValue();
        } else if (Primitives.isByte(this.clazz)) {
            n = p.getByteValue();
        } else if (this.clazz == BigDecimal.class) {
            n = p.getDecimalValue();
        } else if (this.clazz == BigInteger.class) {
            n = p.getBigIntegerValue();
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty beanProperty, Class<?> type) throws JsonMappingException {
        if ((this.handledType() == null || type != null && this.handledType() != type) && Number.class.isAssignableFrom(type)) {
            if (Jacksons.getBooleanAttr(context, "SERIALIZE_LONG_USING_STRING") || Jacksons.getBooleanAttr(context, "SERIALIZE_NUMBER_USING_STRING")) {
                NumberDeserializer d = new NumberDeserializer();
                d.clazz = type;
                return d;
            }
            if (type.getName().startsWith("java.")) {
                return NumberDeserializers.find(type, (String)type.getName());
            }
        }
        return null;
    }
}

