/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CustomizedBeanDeserializer
extends BeanDeserializer {
    public CustomizedBeanDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
    }

    public CustomizedBeanDeserializer(BeanDeserializerBase src) {
        super(src);
    }

    public CustomizedBeanDeserializer(BeanDeserializerBase src, boolean ignoreAllUnknown) {
        super(src, ignoreAllUnknown);
    }

    public CustomizedBeanDeserializer(BeanDeserializerBase src, NameTransformer unwrapper) {
        super(src, unwrapper);
    }

    public CustomizedBeanDeserializer(BeanDeserializerBase src, ObjectIdReader oir) {
        super(src, oir);
    }

    public CustomizedBeanDeserializer(BeanDeserializerBase src, HashSet<String> ignorableProps) {
        super(src, ignorableProps);
    }

    protected void handleUnknownVanilla(JsonParser parser, DeserializationContext ctxt, Object bean, final String propName) throws IOException {
        SettableBeanProperty prop = null;
        PropertyCodecConfiguration propertyCodecConfiguration = Jacksons.getPropertyCodecConfiguration(parser);
        String propName2 = null;
        if (propertyCodecConfiguration != null) {
            propName2 = propertyCodecConfiguration.getName();
        }
        List props = null;
        if (Strings.isNotBlank((String)propName2)) {
            prop = this._beanProperties.find(propName2);
        }
        if (prop == null) {
            props = Pipeline.of((Iterable)this._beanProperties).filter((Predicate)new Predicate<SettableBeanProperty>(){

                public boolean test(SettableBeanProperty settableBeanProperty) {
                    PropertyName propertyName = settableBeanProperty.getFullName();
                    return Strings.equalsIgnoreCase((CharSequence)propertyName.getSimpleName(), (CharSequence)propName);
                }
            }).asList();
        }
        if (Emptys.isNotEmpty(props) && props.size() == 1) {
            prop = (SettableBeanProperty)props.get(0);
        }
        if (prop == null && Strings.isNotBlank((String)propName2)) {
            JsonProperty jsonProperty;
            Method setter;
            JsonProperty jsonProperty2;
            String fixedProperty = null;
            Field field = Reflects.getAnyField(bean.getClass(), (String)propName2);
            if (field != null && (jsonProperty2 = (JsonProperty)Reflects.getAnnotation((AnnotatedElement)field, JsonProperty.class)) != null) {
                fixedProperty = jsonProperty2.value();
            }
            if (Strings.isBlank(fixedProperty) && (setter = Reflects.getSetter(bean.getClass(), (String)propName2)) != null && (jsonProperty = (JsonProperty)Reflects.getAnnotation((AnnotatedElement)setter, JsonProperty.class)) != null) {
                fixedProperty = jsonProperty.value();
            }
            if (Strings.isNotBlank(fixedProperty)) {
                prop = this._beanProperties.find(fixedProperty);
            }
        }
        if (prop != null) {
            try {
                bean = prop.deserializeSetAndReturn(parser, ctxt, bean);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, propName, ctxt);
            }
        } else {
            super.handleUnknownVanilla(parser, ctxt, bean, propName);
        }
    }
}

