/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.knownhosts;

import com.jn.agileway.ssh.client.transport.hostkey.IllegalSshKeyException;
import com.jn.agileway.ssh.client.transport.hostkey.UnsupportedHostsKeyTypeException;
import com.jn.agileway.ssh.client.transport.hostkey.codec.PublicKeyCodecs;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.CommentHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HashedHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.Marker;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.SimpleHostsKeyEntry;
import com.jn.agileway.ssh.client.utils.Buffer;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;

public class KnownHostsFiles {
    private static final Logger logger = Loggers.getLogger(KnownHostsFiles.class);
    private static final String INVALID_KNOWN_HOSTS_LINE_LOG = "invalid known_hosts line: {}";

    public static HostsKeyEntry parseLine(String line) throws Buffer.BufferException {
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return new CommentHostsKeyEntry(line);
        }
        List segments = Collects.asList((Object[])line.split(" "));
        Marker marker = (Marker)Enums.ofName(Marker.class, (String)((String)segments.get(0)));
        if (marker != null) {
            segments = segments.subList(1, segments.size());
        }
        if (segments.size() >= 2) {
            String hosts = (String)segments.get(0);
            String keyTypeString = (String)segments.get(1);
            String publicKeyBase64 = null;
            if (segments.size() == 2) {
                if (((String)segments.get(1)).length() < 25) {
                    logger.warn(INVALID_KNOWN_HOSTS_LINE_LOG, (Object)line);
                    return null;
                }
                Buffer.PlainBuffer buff = new Buffer.PlainBuffer(Base64.decodeBase64((String)((String)segments.get(1))));
                keyTypeString = buff.readString();
                if (buff.available() < 4) {
                    logger.warn(INVALID_KNOWN_HOSTS_LINE_LOG, (Object)line);
                    return null;
                }
                publicKeyBase64 = (String)segments.get(1);
            } else {
                publicKeyBase64 = (String)segments.get(2);
            }
            Object publicKey = null;
            try {
                publicKey = PublicKeyCodecs.decode(Base64.decodeBase64((String)publicKeyBase64));
            }
            catch (UnsupportedHostsKeyTypeException ex) {
                publicKey = publicKeyBase64;
            }
            catch (IllegalSshKeyException ex) {
                logger.error("bad ssh hash key: {}", (Object)line);
                return null;
            }
            if (hosts.startsWith("|1|")) {
                return new HashedHostsKeyEntry(marker, hosts, keyTypeString, publicKey);
            }
            return new SimpleHostsKeyEntry(marker, hosts, keyTypeString, publicKey);
        }
        logger.warn(INVALID_KNOWN_HOSTS_LINE_LOG, (Object)line);
        return null;
    }

    public static List<HostsKeyEntry> read(byte[] knownHostsData) throws IOException {
        List entries = Collects.emptyArrayList();
        List lines = IOs.readLines((InputStream)new ByteArrayInputStream(knownHostsData));
        for (String line : lines) {
            HostsKeyEntry hostsKeyEntry = KnownHostsFiles.parseLine(line);
            if (hostsKeyEntry == null) continue;
            entries.add(hostsKeyEntry);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostsKeyEntry> read(File knownHosts) throws IOException {
        List<HostsKeyEntry> list;
        FileInputStream in = null;
        try {
            in = new FileInputStream(knownHosts);
            byte[] bytes = IOs.toByteArray((InputStream)in);
            list = KnownHostsFiles.read(bytes);
        }
        catch (Throwable throwable) {
            IOs.close(in);
            throw throwable;
        }
        IOs.close((Object)in);
        return list;
    }

    public static void appendHostKeysToFile(File knownHosts, String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        PublicKey publicKey = PublicKeyCodecs.decode(serverHostKey);
        KnownHostsFiles.appendHostKeysToFile(knownHosts, new SimpleHostsKeyEntry(null, Strings.join((String)",", (String[])hostnames), serverHostKeyAlgorithm, publicKey));
    }

    public static void appendHostKeysToFile(File knownHosts, HostsKeyEntry entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (!entry.isValid() && !(entry instanceof CommentHostsKeyEntry)) {
            throw new IllegalArgumentException();
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(knownHosts, true);
            fileWriter.write(entry.getLine());
        }
        catch (Throwable throwable) {
            IOs.close(fileWriter);
            throw throwable;
        }
        IOs.close((Object)fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rewrite(File knownHosts, Collection<HostsKeyEntry> entries) throws IOException {
        BufferedWriter bos = null;
        try {
            Files.makeFile((File)knownHosts);
            bos = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(knownHosts)));
            for (HostsKeyEntry entry : entries) {
                bos.write(entry.getLine());
                bos.newLine();
            }
        }
        catch (Throwable throwable) {
            IOs.close(bos);
            throw throwable;
        }
        IOs.close((Object)bos);
    }
}

