/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.knownhosts;

import com.jn.agileway.ssh.client.transport.hostkey.codec.PublicKeyCodecs;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.Marker;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import java.security.PublicKey;

public abstract class AbstractHostsKeyEntry
implements HostsKeyEntry {
    private Marker marker;
    private String hosts;
    private String keyType;
    private Object publicKey;

    protected AbstractHostsKeyEntry() {
    }

    protected AbstractHostsKeyEntry(Marker marker, String hosts, String keyType, Object publicKey) {
        this.setMarker(marker);
        this.setHosts(hosts);
        this.setKeyType(keyType);
        this.setPublicKey(publicKey);
    }

    @Override
    public boolean applicableTo(String host, String keyType) {
        if (!this.isValid()) {
            return false;
        }
        if (Strings.isNotBlank((String)keyType) && !Objs.equals((Object)this.keyType, (Object)keyType)) {
            return false;
        }
        return this.containsHost(host);
    }

    protected abstract boolean containsHost(String var1);

    @Override
    public boolean verify(Object key) {
        return Objs.deepEquals((Object)PublicKeyCodecs.getPublicKeyBytes(this), (Object)PublicKeyCodecs.getPublicKeyBytes(this)) && this.marker != Marker.REVOKED;
    }

    @Override
    public boolean isValid() {
        return Emptys.isNoneEmpty((Object[])new Object[]{this.keyType, this.hosts, this.publicKey});
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setPublicKey(Object publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    public Object getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getLine() {
        return this.getLine(true);
    }

    protected String getLine(boolean dumpPublicKey) {
        if (this.isValid()) {
            if (this.getMarker() == null) {
                return StringTemplates.formatWithPlaceholder((String)"{} {}{}", (Object[])new Object[]{this.getHosts(), this.getKeyType(), dumpPublicKey ? " " + this.getPublicKeyBase64() : ""});
            }
            return StringTemplates.formatWithPlaceholder((String)"{} {} {}{}", (Object[])new Object[]{this.getMarker().getName(), this.getHosts(), this.getKeyType(), dumpPublicKey ? " " + this.getPublicKeyBase64() : ""});
        }
        return "invalid";
    }

    private String getPublicKeyBase64() {
        if (this.publicKey == null) {
            return null;
        }
        if (this.publicKey instanceof PublicKey) {
            return Base64.encodeBase64String((byte[])PublicKeyCodecs.encode((PublicKey)this.publicKey));
        }
        if (this.publicKey instanceof byte[]) {
            return Base64.encodeBase64String((byte[])((byte[])this.publicKey));
        }
        if (this.publicKey instanceof String) {
            return (String)this.publicKey;
        }
        return this.publicKey.toString();
    }

    public String toString() {
        return this.getLine(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHostsKeyEntry that = (AbstractHostsKeyEntry)o;
        if (!Objs.equals((Object)((Object)this.marker), (Object)((Object)that.marker))) {
            return false;
        }
        if (!Objs.equals((Object)this.hosts, (Object)that.hosts)) {
            return false;
        }
        if (!Objs.equals((Object)this.keyType, (Object)that.keyType)) {
            return false;
        }
        return Objs.equals((Object)PublicKeyCodecs.toPublicKeyBytes(this.publicKey), (Object)PublicKeyCodecs.toPublicKeyBytes(that.publicKey));
    }

    public int hashCode() {
        return Objs.hash((Object[])new Object[]{this.marker, this.hosts, this.keyType, PublicKeyCodecs.toPublicKeyBytes(this.publicKey)});
    }
}

