/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp.attrs;

import com.jn.agileway.ssh.client.sftp.attrs.FileMode;
import com.jn.agileway.ssh.client.sftp.attrs.FileType;
import com.jn.langx.util.Dates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.io.file.FilePermission;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class FileAttrs {
    private Long size = null;
    private Integer uid = null;
    private Integer gid = null;
    private FileMode fileMode;
    private Integer atime = null;
    private Integer mtime = null;
    private Map<String, String> extendProperties = Collects.emptyHashMap();

    public Long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Integer getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public Integer getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public FileMode getFileMode() {
        return this.fileMode;
    }

    public void setFileMode(FileMode fileMode) {
        this.fileMode = fileMode;
    }

    public Integer getAccessTime() {
        return this.atime;
    }

    public void setAccessTime(int accessTime) {
        this.atime = accessTime;
    }

    public Integer getModifyTime() {
        return this.mtime;
    }

    public void setModifyTime(int modifyTime) {
        this.mtime = modifyTime;
    }

    public String getExtend(String key) {
        return this.extendProperties.get(key);
    }

    public void setExtend(String key, String value) {
        this.extendProperties.put(key, value);
    }

    public Set<String> getExtendKeys() {
        return this.extendProperties.keySet();
    }

    public boolean isDirectory() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.DIRECTORY;
        }
        return false;
    }

    public boolean isFile() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.REGULAR;
        }
        return false;
    }

    public boolean isSocket() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.SOCKET_SPECIAL;
        }
        return false;
    }

    public boolean isBlock() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.BLOCK_SPECIAL;
        }
        return false;
    }

    public boolean isChar() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.CHAR_SPECIAL;
        }
        return false;
    }

    public boolean isLink() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.SYMBOLIC_LINK;
        }
        return false;
    }

    public boolean isFIFO() {
        if (this.fileMode != null) {
            return this.fileMode.getType() == FileType.FIFO_SPECIAL;
        }
        return false;
    }

    public FileType getFileType() {
        if (this.fileMode != null) {
            return this.fileMode.getType();
        }
        return FileType.UNKNOWN;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        if (this.fileMode != null) {
            builder.append(this.fileMode.getType().getDisplayText());
            Set<FilePermission> filePermissions = this.fileMode.getPermissions();
            builder.append(filePermissions.contains(FilePermission.USR_R) ? "r" : "-");
            builder.append(filePermissions.contains(FilePermission.USR_W) ? "w" : "-");
            builder.append(filePermissions.contains(FilePermission.USR_X) ? "x" : "-");
            builder.append(filePermissions.contains(FilePermission.GRP_R) ? "r" : "-");
            builder.append(filePermissions.contains(FilePermission.GRP_W) ? "w" : "-");
            builder.append(filePermissions.contains(FilePermission.GRP_X) ? "x" : "-");
            builder.append(filePermissions.contains(FilePermission.OTH_R) ? "r" : "-");
            builder.append(filePermissions.contains(FilePermission.OTH_W) ? "w" : "-");
            builder.append(filePermissions.contains(FilePermission.OTH_X) ? "x" : "-");
            builder.append(" ");
        }
        if (this.size != null) {
            builder.append(this.size).append(" ");
        }
        if (this.mtime != null) {
            builder.append(Dates.format((Date)new Date((long)this.mtime.intValue() * 1000L), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return builder.toString();
    }
}

