/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.sftp;

import com.jn.agileway.ssh.client.sftp.SftpFile;
import com.jn.langx.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class SftpFileInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final SftpFile sftpFile;
    private long filePosition = 0L;
    private final transient ByteBuffer byteBuffer;

    public SftpFileInputStream(SftpFile sftpFile) {
        this(sftpFile, 8192);
    }

    public SftpFileInputStream(SftpFile sftpFile, int buffSize) {
        this(sftpFile, buffSize, 0L);
    }

    public SftpFileInputStream(SftpFile sftpFile, int buffSize, long filePosition) {
        Preconditions.checkNotNull((Object)sftpFile);
        this.sftpFile = sftpFile;
        Preconditions.checkTrue((buffSize > 0 ? 1 : 0) != 0);
        this.byteBuffer = ByteBuffer.allocate(buffSize);
        Preconditions.checkTrue((filePosition >= 0L ? 1 : 0) != 0);
        this.filePosition = filePosition;
    }

    private int doRead() throws IOException {
        this.byteBuffer.clear();
        int length = this.sftpFile.read(this.filePosition, this.byteBuffer.array(), 0, this.byteBuffer.capacity());
        if (length != -1) {
            this.filePosition += (long)length;
            this.byteBuffer.position(0);
            this.byteBuffer.limit(length);
        }
        return length;
    }

    @Override
    public int read() throws IOException {
        int length;
        if (!(this.byteBuffer.position() != 0 && this.byteBuffer.hasRemaining() || (length = this.doRead()) != -1)) {
            return -1;
        }
        int v = this.byteBuffer.get();
        return v < 0 ? v + 256 : v;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.sftpFile.getAttributes().getSize() - this.filePosition);
    }

    @Override
    public void close() throws IOException {
        this.sftpFile.close();
    }
}

